/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import leap.lang.Enumerable;
import leap.lang.Iterables;
import leap.lang.New;
import leap.lang.exception.EmptyElementsException;
import leap.lang.exception.TooManyElementsException;

public abstract class AbstractEnumerable<E>
implements Enumerable<E> {
    @Override
    public E first() throws EmptyElementsException {
        if (this.size() == 0) {
            throw new EmptyElementsException();
        }
        return this.get(0);
    }

    @Override
    public E firstOrNull() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public E firstOrNull(Predicate<? super E> predicate) {
        return Iterables.firstOrNull(this, predicate);
    }

    @Override
    public E single() throws EmptyElementsException, TooManyElementsException {
        int size = this.size();
        if (size == 0) {
            throw new EmptyElementsException();
        }
        if (size > 1) {
            throw new TooManyElementsException();
        }
        return this.get(0);
    }

    @Override
    public E singleOrNull() throws TooManyElementsException {
        int size = this.size();
        if (size == 0) {
            return null;
        }
        if (size > 1) {
            throw new TooManyElementsException();
        }
        return this.get(0);
    }

    @Override
    public Object[] toArray() {
        return Iterables.toArray(this);
    }

    @Override
    public E[] toArray(Class<E> type) {
        return Iterables.toArray(this, type);
    }

    @Override
    public List<E> toList() {
        return New.arrayList(this);
    }

    @Override
    public Set<E> toSet() {
        return New.linkedHashSet(this);
    }
}

