/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.util.Iterator;
import leap.lang.Arrays2;
import leap.lang.Enumerable;
import leap.lang.Immutable;
import leap.lang.collection.AbstractEnumerable;
import leap.lang.collection.ArrayIterator;

public class ArrayIterable<E>
extends AbstractEnumerable<E>
implements Iterable<E>,
Immutable,
Enumerable<E> {
    protected final E[] values;

    public static <E> ArrayIterable<E> of(E ... values) {
        return new ArrayIterable<E>(values);
    }

    public ArrayIterable(E ... values) {
        this.values = values;
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayIterator<E>(this.values);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public E get(int index) {
        return this.values[index];
    }

    @Override
    public boolean contains(Object element) {
        return Arrays2.contains(this.values, element);
    }

    @Override
    public Object[] toArray() {
        return Arrays2.copyOf(this.values);
    }

    @Override
    public E[] toArray(Class<E> type) {
        return Arrays2.copyOf(this.values);
    }
}

