/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.lang.reflect.Array;
import java.util.Iterator;
import leap.lang.Args;
import leap.lang.Arrays2;
import leap.lang.Enumerable;
import leap.lang.Immutable;
import leap.lang.collection.AbstractEnumerable;
import leap.lang.collection.ArrayObjectIterator;

public class ArrayObjectIterable<E>
extends AbstractEnumerable<E>
implements Iterable<E>,
Immutable,
Enumerable<E> {
    protected final Object array;
    protected final int length;

    public static <E> ArrayObjectIterable<E> of(Object array) {
        return new ArrayObjectIterable<E>(array);
    }

    public ArrayObjectIterable(Object array) {
        Args.notNull(array, "array object");
        this.array = array;
        this.length = Array.getLength(array);
    }

    @Override
    public Iterator<E> iterator() {
        return new ArrayObjectIterator(this.array, this.length);
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length <= 0;
    }

    @Override
    public E get(int index) {
        return (E)Array.get(this.array, index);
    }

    @Override
    public boolean contains(Object element) {
        return Arrays2.containsInObjectArray(this.array, element);
    }
}

