/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import leap.lang.collection.UnmodifiableIterator;

public class ArrayObjectIterator<E>
extends UnmodifiableIterator<E>
implements Iterator<E> {
    private final Object array;
    private final int length;
    private int current = -1;

    public ArrayObjectIterator(Object array) {
        this.array = array;
        this.length = Array.getLength(array);
    }

    protected ArrayObjectIterator(Object array, int length) {
        this.array = array;
        this.length = length;
    }

    @Override
    public boolean hasNext() {
        return this.current < this.length - 1;
    }

    @Override
    public E next() {
        try {
            return (E)Array.get(this.array, ++this.current);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }
}

