/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import leap.lang.Arrays2;
import leap.lang.Enumerable;
import leap.lang.collection.EmptyIterator;
import leap.lang.exception.EmptyElementsException;
import leap.lang.exception.TooManyElementsException;

public final class EmptyIterable<E>
implements Iterable<E>,
Enumerable<E> {
    private static EmptyIterable INSTANCE = new EmptyIterable();
    private EmptyIterator<E> iterator = new EmptyIterator();

    public static final <T> EmptyIterable<T> instance() {
        return INSTANCE;
    }

    @Override
    public Iterator<E> iterator() {
        return this.iterator;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public E get(int index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException("invalid index '" + index + "' for empty collection");
    }

    @Override
    public boolean contains(Object element) {
        return false;
    }

    @Override
    public E first() throws EmptyElementsException {
        throw new EmptyElementsException();
    }

    @Override
    public E firstOrNull() {
        return null;
    }

    @Override
    public E firstOrNull(Predicate<? super E> predicate) {
        return null;
    }

    @Override
    public E single() throws EmptyElementsException, TooManyElementsException {
        throw new EmptyElementsException();
    }

    @Override
    public E singleOrNull() throws TooManyElementsException {
        return null;
    }

    @Override
    public Object[] toArray() {
        return Arrays2.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public E[] toArray(Class<E> type) {
        return Arrays2.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public List<E> toList() {
        return new ArrayList(1);
    }

    @Override
    public Set<E> toSet() {
        return new LinkedHashSet(1);
    }
}

