/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.util.HashMap;
import java.util.Map;
import leap.lang.collection.CaseInsensitiveMap;
import leap.lang.enums.CaseType;

public class SimpleCaseInsensitiveMap<V>
extends HashMap<String, V>
implements CaseInsensitiveMap<V> {
    private static final long serialVersionUID = 7737207181956011290L;
    private final CaseType caseType;

    public SimpleCaseInsensitiveMap() {
        this.caseType = CaseType.UPPER;
    }

    public SimpleCaseInsensitiveMap(CaseType caseType) {
        this.caseType = caseType;
    }

    public SimpleCaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
        this.caseType = CaseType.UPPER;
    }

    public SimpleCaseInsensitiveMap(int initialCapacity, CaseType caseType) {
        super(initialCapacity);
        this.caseType = caseType;
    }

    public SimpleCaseInsensitiveMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.caseType = CaseType.UPPER;
    }

    public SimpleCaseInsensitiveMap(int initialCapacity, float loadFactor, CaseType caseType) {
        super(initialCapacity, loadFactor);
        this.caseType = caseType;
    }

    public SimpleCaseInsensitiveMap(Map<? extends String, ? extends V> m) {
        this.caseType = CaseType.UPPER;
        this.putAll(m);
    }

    public SimpleCaseInsensitiveMap(Map<? extends String, ? extends V> m, CaseType caseType) {
        this.caseType = caseType;
        this.putAll(m);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(this.caseObjectKey(key));
    }

    @Override
    public V get(Object key) {
        return super.get(this.caseObjectKey(key));
    }

    @Override
    public V put(String key, V value) {
        return super.put(this.caseStringKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        if (null == map) {
            return;
        }
        for (Map.Entry<String, V> entry : map.entrySet()) {
            super.put(this.caseStringKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return super.remove(this.caseObjectKey(key));
    }

    protected final String caseStringKey(String key) {
        return null == key ? null : key.toUpperCase();
    }

    protected final String caseObjectKey(Object key) {
        return null == key ? null : key.toString().toUpperCase();
    }

    protected String caseString(String string) {
        return this.caseType.get(string);
    }
}

