/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.collection;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import leap.lang.Args;
import leap.lang.collection.CaseInsensitiveMap;
import leap.lang.value.SimpleEntry;

public class WrappedCaseInsensitiveMap<V>
implements Map<String, V>,
CaseInsensitiveMap<V>,
Serializable {
    private static final long serialVersionUID = -4254530641694177354L;
    private final Map<CaseInsensitiveKey, V> map;

    public static <V> WrappedCaseInsensitiveMap<V> create() {
        return new WrappedCaseInsensitiveMap<V>();
    }

    public static <V> WrappedCaseInsensitiveMap<V> create(Map<? extends String, ? extends V> m) {
        WrappedCaseInsensitiveMap<? extends V> map = new WrappedCaseInsensitiveMap<V>();
        map.putAll((Map<String, ? extends V>)m);
        return map;
    }

    public static <V> WrappedCaseInsensitiveMap<V> wrap(Map<CaseInsensitiveKey, V> map) {
        return new WrappedCaseInsensitiveMap<V>(map);
    }

    public static <V> WrappedCaseInsensitiveMap<V> wrap(Map<CaseInsensitiveKey, V> map, Map<? extends String, ? extends V> m) {
        WrappedCaseInsensitiveMap<? extends V> wrapped = new WrappedCaseInsensitiveMap<V>(map);
        wrapped.putAll((Map<String, ? extends V>)m);
        return wrapped;
    }

    public WrappedCaseInsensitiveMap() {
        this.map = new HashMap<CaseInsensitiveKey, V>();
    }

    public WrappedCaseInsensitiveMap(int initialCapacity) {
        this.map = new HashMap<CaseInsensitiveKey, V>(initialCapacity);
    }

    public WrappedCaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this.map = new HashMap<CaseInsensitiveKey, V>(initialCapacity, loadFactor);
    }

    public WrappedCaseInsensitiveMap(Map<CaseInsensitiveKey, V> map) {
        Args.notNull(map, "wrapped map");
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        if (null == key) {
            return false;
        }
        return this.map.containsKey(new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(null == key ? null : new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public V put(String key, V value) {
        return this.map.put(null == key ? null : new CaseInsensitiveKey(key), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        if (null == m) {
            return;
        }
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(null == key ? null : new CaseInsensitiveKey(key.toString()));
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == WrappedCaseInsensitiveMap.class) {
            return this.map.equals(((WrappedCaseInsensitiveMap)obj).map);
        }
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return 629 + this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new EntrySet(this.map);
    }

    @Override
    public Set<String> keySet() {
        return new KeySet(this.map);
    }

    public static final class CaseInsensitiveKey {
        private final String key;

        private CaseInsensitiveKey(String key) {
            this.key = key;
        }

        public int hashCode() {
            return 629 + this.key.toLowerCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != CaseInsensitiveKey.class) {
                return false;
            }
            return this.key.equalsIgnoreCase(((CaseInsensitiveKey)obj).key);
        }

        public String toString() {
            return this.key;
        }
    }

    private static class KeySetIterator
    implements Iterator<String> {
        private final Iterator<CaseInsensitiveKey> iterator;

        private KeySetIterator(Iterator<CaseInsensitiveKey> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next().key;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class KeySet
    extends AbstractSet<String> {
        private final Map<CaseInsensitiveKey, ?> map;
        private final KeySetIterator iterator;

        private KeySet(Map<CaseInsensitiveKey, ?> map) {
            this.map = map;
            this.iterator = new KeySetIterator(map.keySet().iterator());
        }

        @Override
        public Iterator<String> iterator() {
            return this.iterator;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private static class EntrySetIterator<V>
    implements Iterator<Map.Entry<String, V>> {
        private final Iterator<Map.Entry<CaseInsensitiveKey, V>> iterator;

        private EntrySetIterator(Iterator<Map.Entry<CaseInsensitiveKey, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            Map.Entry<CaseInsensitiveKey, V> entry = this.iterator.next();
            return new SimpleEntry<String, V>(entry.getKey().key, entry.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class EntrySet<V>
    extends AbstractSet<Map.Entry<String, V>> {
        private final Map<CaseInsensitiveKey, V> map;
        private final EntrySetIterator<V> iterator;

        private EntrySet(Map<CaseInsensitiveKey, V> map) {
            this.map = map;
            this.iterator = new EntrySetIterator(map.entrySet().iterator());
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return this.iterator;
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }
}

