/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.Types;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;

public abstract class AbstractCollectionConverter<T extends Collection>
extends AbstractConverter<T> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        Class elementType;
        Class clazz = elementType = null == genericType ? Object.class : Types.getActualTypeArgument(genericType);
        if (value instanceof Iterable) {
            out.set(this.toCollection(targetType, elementType, (Iterable)value, context));
            return true;
        }
        if (value.getClass().isArray()) {
            out.set(this.toCollection(targetType, elementType, (Object[])value, context));
            return true;
        }
        if (value instanceof CharSequence) {
            out.set(this.toCollection(targetType, elementType, value.toString()));
            return true;
        }
        return false;
    }

    @Override
    public String convertToString(T collection) throws Throwable {
        StringBuilder buf = new StringBuilder(100);
        int i = 0;
        for (Object value : collection) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(Converts.toString(value));
            ++i;
        }
        return buf.toString();
    }

    public T toCollection(Class<?> targetType, Class<?> elementType, Iterable iterable, ConvertContext context) throws Throwable {
        T collection = this.newInstance(targetType);
        for (Object e : iterable) {
            collection.add(Converts.convert(e, elementType, context));
        }
        return collection;
    }

    public T toCollection(Class<?> targetType, Class<?> elementType, Object[] array, ConvertContext context) throws Throwable {
        T collection = this.newInstance(targetType);
        for (Object e : array) {
            collection.add(Converts.convert(e, elementType, context));
        }
        return collection;
    }

    public T toCollectionFromArray(Class<?> targetType, Class<?> elementType, Object array, ConvertContext context) throws Throwable {
        T collection = this.newInstance(targetType);
        for (int i = 0; i < Array.getLength(array); ++i) {
            collection.add(Converts.convert(Array.get(array, i), elementType, context));
        }
        return collection;
    }

    public T toCollection(Class<?> targetType, Class<?> elementType, String stringValue) throws Throwable {
        String[] stringArray = Strings.split(stringValue);
        T collection = this.newInstance(targetType);
        for (String string : stringArray) {
            collection.add(Converts.convert(string, elementType));
        }
        return collection;
    }

    protected abstract T newInstance(Class<?> var1);
}

