/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.Date;
import leap.lang.Dates;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.ConvertException;
import leap.lang.time.DateFormats;

public abstract class AbstractDateConverter<T>
extends AbstractConverter<T> {
    protected String[] patterns;

    public AbstractDateConverter() {
    }

    public AbstractDateConverter(String pattern) {
        this.patterns = new String[]{pattern};
    }

    public AbstractDateConverter(String[] patterns) {
        this.patterns = patterns;
    }

    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof Date) {
            out.set(this.convertFrom(targetType, (Date)value));
            return true;
        }
        if (value instanceof Calendar) {
            out.set(this.convertFrom(targetType, (Calendar)value));
            return true;
        }
        if (value instanceof Long) {
            out.set(this.convertFrom(targetType, (Long)value));
            return true;
        }
        if (value instanceof Number) {
            out.set(this.convertFrom(targetType, ((Number)value).longValue()));
            return true;
        }
        if (value instanceof CharSequence) {
            String stringValue = value.toString();
            if (Strings.isDigits(stringValue)) {
                out.set(this.convertFrom(targetType, Long.parseLong(stringValue)));
            } else {
                out.set(this.convertFrom(targetType, stringValue));
            }
            return true;
        }
        return false;
    }

    @Override
    public String convertToString(T value) throws Throwable {
        return DateFormats.getFormat(value.getClass()).format((Date)value);
    }

    public void setPattern(String pattern) {
        this.patterns = new String[]{pattern};
    }

    public void setPatterns(String[] patterns) {
        this.patterns = patterns;
    }

    protected abstract T convertFrom(Class<?> var1, Date var2);

    protected abstract T convertFrom(Class<?> var1, Calendar var2);

    protected abstract T convertFrom(Class<?> var1, Long var2);

    protected T convertFrom(Class<?> targetType, String stringValue) {
        if (null == this.patterns || this.patterns.length == 0) {
            return this.convertFrom(targetType, Dates.parse(stringValue, DateFormats.getPattern(targetType)));
        }
        for (String pattern : this.patterns) {
            Date date = Dates.tryParse(stringValue, pattern);
            if (null == date) continue;
            return this.convertFrom(targetType, date);
        }
        throw new ConvertException("cannot convert string '" + stringValue + "' to '" + targetType.getName() + "'");
    }
}

