/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import java.time.Instant;
import leap.lang.Out;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converter;
import leap.lang.convert.Converts;

public abstract class AbstractDateTimeConverter<T>
implements Converter<T> {
    @Override
    public boolean convertTo(T value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (targetType.equals(Instant.class)) {
            out.set(this.convertToInstant(value));
            return true;
        }
        return false;
    }

    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof CharSequence) {
            out.set(this.convertFromString((CharSequence)value));
            return true;
        }
        if (value instanceof Long) {
            out.set(this.convertFromLong((Long)value));
            return true;
        }
        Instant instant = Converts.tryConvert(value, Instant.class, genericType);
        if (null == instant) {
            return false;
        }
        out.set(this.convertFromInstant(instant));
        return true;
    }

    protected T convertFromLong(long l) {
        return this.convertFromInstant(Instant.ofEpochMilli(l));
    }

    protected abstract T convertFromString(CharSequence var1);

    protected abstract T convertFromInstant(Instant var1);

    protected abstract Instant convertToInstant(T var1);
}

