/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import leap.lang.Out;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;

public abstract class AbstractNumberConverter<T extends Number>
extends AbstractConverter<T> {
    private static final Integer ZERO = new Integer(0);
    private static final Integer ONE = new Integer(1);
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof Number) {
            out.set(this.toNumber(targetType, (Number)value));
        } else if (value instanceof Boolean) {
            out.set(this.toNumber(targetType, (Boolean)value != false ? ONE : ZERO));
        } else {
            out.set(this.toNumber(targetType, value));
        }
        return true;
    }

    protected T toNumber(Class<?> targetType, Object value) {
        String string = value.toString();
        if (string.equalsIgnoreCase(TRUE)) {
            return this.toNumber(targetType, ONE);
        }
        if (string.equalsIgnoreCase(FALSE)) {
            return this.toNumber(targetType, ZERO);
        }
        return this.toNumber(targetType, string);
    }

    protected abstract T toNumber(Class<?> var1, Number var2);

    protected abstract T toNumber(Class<?> var1, String var2);
}

