/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Collection;
import leap.lang.Out;
import leap.lang.Strings;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;

public class ArrayConverter
extends AbstractConverter<Object> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        Class<?> sourceType = value.getClass();
        Class<?> targetComponentType = targetType.getComponentType();
        if (sourceType.isArray()) {
            Class<?> sourceCompoenentType = sourceType.getComponentType();
            if (targetComponentType.isAssignableFrom(sourceCompoenentType)) {
                out.set(value);
            } else {
                int length = Array.getLength(value);
                Object array = Array.newInstance(targetComponentType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(array, i, Converts.convert(Array.get(value, i), targetComponentType));
                }
                out.set(array);
            }
            return true;
        }
        if (value instanceof CharSequence) {
            out.set(ArrayConverter.stringToArray(value.toString(), targetComponentType));
            return true;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            out.set(ArrayConverter.iterableToArray(collection, targetComponentType, collection.size()));
            return true;
        }
        if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            int length = 0;
            for (Object e : iterable) {
                ++length;
            }
            out.set(ArrayConverter.iterableToArray(iterable, targetComponentType, length));
            return true;
        }
        return false;
    }

    @Override
    public String convertToString(Object array) throws Throwable {
        StringBuilder string = new StringBuilder(128);
        for (int i = 0; i < Array.getLength(array); ++i) {
            if (i > 0) {
                string.append(',');
            }
            string.append(Converts.toString(Array.get(array, i)));
        }
        return string.toString();
    }

    private static Object iterableToArray(Iterable<?> iterable, Class<?> componentType, int length) {
        Object array = Array.newInstance(componentType, length);
        if (length > 0) {
            int index = 0;
            for (Object element : iterable) {
                Array.set(array, index++, Converts.convert(element, componentType));
            }
        }
        return array;
    }

    private static Object stringToArray(String string, Class<?> componentType) {
        String[] strings = Strings.split(string, ',');
        Object array = Array.newInstance(componentType, strings.length);
        for (int i = 0; i < strings.length; ++i) {
            Array.set(array, i, Converts.convert(strings[i], componentType));
        }
        return array;
    }
}

