/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import leap.lang.Objects2;
import leap.lang.Out;
import leap.lang.annotation.Name;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.ConvertException;
import leap.lang.convert.Converts;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectConstructor;
import leap.lang.reflect.ReflectParameter;
import leap.lang.serialize.Serialize;
import leap.lang.serialize.Serializer;
import leap.lang.serialize.Serializes;

public class BeanConverter
extends AbstractConverter<Object> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof Map) {
            out.set(this.convertFromMap(targetType, genericType, (Map)value, context));
            return true;
        }
        return false;
    }

    @Override
    public boolean convertTo(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (Map.class.isAssignableFrom(targetType)) {
            out.set(this.convertToMap(value));
            return true;
        }
        return false;
    }

    protected Object convertFromMap(Class<?> targetType, Type genericType, Map map, ConvertContext context) {
        BeanType bt = BeanType.of(targetType);
        Object bean = this.newInstance(context, bt, map);
        if (bean.getClass() != targetType) {
            bt = BeanType.of(bean.getClass());
        }
        block0: for (BeanProperty prop : bt.getProperties()) {
            String name = prop.getName();
            boolean multiNames = false;
            for (Annotation a : prop.getAnnotations()) {
                Name nameAnnotation = a.annotationType().getAnnotation(Name.class);
                if (null == nameAnnotation) continue;
                name = (String)ReflectClass.of(a.getClass()).getMethod(nameAnnotation.value()).invoke(a, new Object[0]);
                multiNames = true;
                break;
            }
            Serializer serializer = Serializes.getSerializer(prop.getAnnotation(Serialize.class));
            for (Map.Entry entryObject : map.entrySet()) {
                Map.Entry entry = entryObject;
                String key = Objects2.toStringOrEmpty(entry.getKey());
                if (!name.equalsIgnoreCase(key) && (!multiNames || !prop.getName().equalsIgnoreCase(key))) continue;
                Object param = entry.getValue();
                if (null != serializer && null != param && param instanceof String) {
                    param = serializer.tryDeserialize((String)param);
                }
                if (!prop.isWritable()) continue;
                prop.setValue(bean, Converts.convert(param, prop.getType(), prop.getGenericType(), context));
                continue block0;
            }
        }
        return bean;
    }

    protected Object newInstance(ConvertContext context, BeanType bt, Map<String, Object> map) {
        Object instance;
        ConvertContext.ConcreteTypes types;
        ReflectClass cls = bt.getReflectClass();
        ConvertContext.ConcreteTypes concreteTypes = types = null == context ? null : context.getConcreteTypes();
        if (null != types && null != (instance = types.newInstance(context, bt.getBeanClass(), null, map))) {
            return instance;
        }
        if (cls.isAbstract() || cls.isInterface()) {
            throw new ConvertException("Cannot new instance for abstract class or interface '" + bt.getBeanClass().getName() + "'");
        }
        if (cls.hasDefaultConstructor()) {
            return bt.newInstance();
        }
        ReflectConstructor c = cls.getConstructors()[0];
        ReflectParameter[] ps = c.getParameters();
        Object[] args = new Object[c.getParameters().length];
        for (int i = 0; i < args.length; ++i) {
            ReflectParameter p = ps[i];
            args[i] = Converts.convert(map.get(p.getName()), p.getType(), p.getGenericType(), context);
        }
        return c.newInstance(args);
    }

    protected Map<String, Object> convertToMap(Object bean) {
        BeanType beanType = BeanType.of(bean.getClass());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (BeanProperty prop : beanType.getProperties()) {
            if (!prop.isReadable()) continue;
            map.put(prop.getName(), prop.getValue(bean));
        }
        return map;
    }
}

