/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import java.sql.Blob;
import leap.lang.Charsets;
import leap.lang.Out;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;
import leap.lang.io.IO;
import leap.lang.jdbc.SimpleBlob;

public class BlobConverter
extends AbstractConverter<Blob> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof byte[]) {
            out.set(new SimpleBlob((byte[])value));
            return true;
        }
        return false;
    }

    @Override
    public boolean convertTo(Blob value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        byte[] data = IO.readByteArray(value.getBinaryStream());
        out.set(Converts.convert((Object)data, targetType, genericType));
        return true;
    }

    @Override
    public String convertToString(Blob value) throws Throwable {
        return IO.readString(value.getBinaryStream(), Charsets.UTF_8);
    }
}

