/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import leap.lang.Out;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converter;
import leap.lang.convert.Converts;

public class BooleanConverter
extends AbstractConverter<Boolean>
implements Converter<Boolean> {
    private String[] trueStrings = new String[]{"true", "yes", "y", "on", "1"};
    private String[] falseStrings = new String[]{"false", "no", "n", "off", "0"};

    public BooleanConverter() {
    }

    public BooleanConverter(String[] trueStrings, String[] falseStrings) {
        this.trueStrings = BooleanConverter.copyStrings(trueStrings);
        this.falseStrings = BooleanConverter.copyStrings(falseStrings);
    }

    @Override
    public boolean convertTo(Boolean value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (Number.class.isAssignableFrom(targetType)) {
            out.set(Converts.convert(value != false ? 1 : 0, targetType));
            return true;
        }
        if (Character.class.equals(targetType)) {
            out.set(Character.valueOf(value != false ? (char)'1' : '0'));
            return true;
        }
        return false;
    }

    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        int i;
        byte[] bytes;
        Class<?> type = value.getClass();
        if (type.equals(byte[].class) && (bytes = (byte[])value).length == 1) {
            byte b = bytes[0];
            if (b == 0) {
                out.set(Boolean.FALSE);
            } else {
                out.set(Boolean.TRUE);
            }
            return true;
        }
        String stringValue = value.toString().toLowerCase();
        for (i = 0; i < this.trueStrings.length; ++i) {
            if (!this.trueStrings[i].equals(stringValue)) continue;
            out.set(Boolean.TRUE);
            return true;
        }
        for (i = 0; i < this.falseStrings.length; ++i) {
            if (!this.falseStrings[i].equals(stringValue)) continue;
            out.set(Boolean.FALSE);
            return true;
        }
        return false;
    }

    private static String[] copyStrings(String[] src) {
        String[] dst = new String[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = src[i].toLowerCase();
        }
        return dst;
    }
}

