/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Args;
import leap.lang.Classes;
import leap.lang.Enums;
import leap.lang.Out;
import leap.lang.Primitives;
import leap.lang.Strings;
import leap.lang.Valued;
import leap.lang.convert.ArrayConverter;
import leap.lang.convert.BeanConverter;
import leap.lang.convert.BlobConverter;
import leap.lang.convert.BooleanConverter;
import leap.lang.convert.CharacterConverter;
import leap.lang.convert.CharsetConverter;
import leap.lang.convert.ClassConverter;
import leap.lang.convert.ClobConverter;
import leap.lang.convert.CollectionConverters;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.ConvertException;
import leap.lang.convert.ConvertUnsupportedException;
import leap.lang.convert.Converter;
import leap.lang.convert.ConvertibleTo;
import leap.lang.convert.DateTimeConverters;
import leap.lang.convert.EnumConverter;
import leap.lang.convert.InputStreamConverter;
import leap.lang.convert.LocaleConverter;
import leap.lang.convert.MapConverter;
import leap.lang.convert.MethodConverter;
import leap.lang.convert.NumberConverters;
import leap.lang.convert.StringConverter;
import leap.lang.convert.StringConvertibleTo;
import leap.lang.meta.MSimpleType;
import leap.lang.value.Null;

public class Converts {
    private static final Map<Class<?>, Converter<?>> converters = new ConcurrentHashMap();
    private static final Map<Class<?>, Converter> assignableFromConverters = new ConcurrentHashMap();
    private static final Object NOT_CONVERTED = new Object();
    private static Converter beanConverter = new BeanConverter();
    private static Converter arrayConverter = new ArrayConverter();
    private static Converter enumConverter = new EnumConverter();
    private static CollectionConverters.ListConverter listConverter = new CollectionConverters.ListConverter();

    protected Converts() {
    }

    public static void register(Class<?> clazz, Converter<?> converter) {
        converters.put(clazz, converter);
    }

    public static void registerAssignableFrom(Class<?> superType, Converter<?> converter) {
        assignableFromConverters.put(superType, converter);
    }

    public static <T> T convert(Object value, Class<T> targetType) throws ConvertUnsupportedException {
        return Converts.convert(value, targetType, null, null);
    }

    public static <T> T convert(Object value, Class<T> targetType, Type genericType) throws ConvertUnsupportedException {
        return Converts.convert(value, targetType, genericType, null);
    }

    public static <T> T convert(Object value, Class<T> targetType, ConvertContext context) throws ConvertUnsupportedException {
        return Converts.convert(value, targetType, null, context);
    }

    public static <T> T convert(Object value, Class<T> targetType, Type genericType, ConvertContext context) throws ConvertUnsupportedException {
        Object v = Converts.doConvert(value, targetType, genericType, context);
        if (NOT_CONVERTED == v) {
            throw new ConvertUnsupportedException(Strings.format("Cannot convert '{0}' to '{1}', value : {2}", value.getClass(), targetType.getName(), value.toString()));
        }
        return (T)v;
    }

    public static <T> T tryConvert(Object value, Class<T> targetType, Type genericType) {
        Object v = Converts.doConvert(value, targetType, genericType, null);
        if (NOT_CONVERTED == v) {
            return null;
        }
        return (T)v;
    }

    protected static <T> Object doConvert(Object value, Class<T> targetType, Type genericType, ConvertContext context) {
        Args.notNull(targetType, "targetType");
        if (!CharSequence.class.isAssignableFrom(targetType)) {
            value = Converts.trimToNull(value);
        }
        if (targetType.isPrimitive()) {
            return Converts.toPrimitive(value, targetType);
        }
        if (null == value || Null.is(value)) {
            return Classes.getDefaultValue(targetType);
        }
        Class<?> sourceType = value.getClass();
        if (targetType.equals(sourceType)) {
            return value;
        }
        if (targetType.equals(String.class)) {
            return Converts.toString(value);
        }
        if (sourceType.isEnum()) {
            value = Enums.getValue((Enum)value);
            sourceType = value.getClass();
        }
        if (targetType.isEnum()) {
            return Enums.valueOf(targetType, value);
        }
        try {
            Out<Object> out = new Out<Object>();
            if (value instanceof ConvertibleTo && ((ConvertibleTo)value).convertTo(targetType, genericType, out)) {
                return out.getValue();
            }
            Converter converter = Converts.findConverter(targetType);
            if (null != converter && converter.convertFrom(value, targetType, genericType, out, context)) {
                return out.getValue();
            }
            converter = Converts.findConverter(sourceType);
            if (null != converter && converter.convertTo(value, targetType, genericType, out, context)) {
                return out.getValue();
            }
            if (targetType.isAssignableFrom(sourceType)) {
                return value;
            }
            for (Map.Entry<Class<?>, Converter> entry : assignableFromConverters.entrySet()) {
                Class<Object> superType = entry.getKey();
                if (superType.isAssignableFrom(targetType) && entry.getValue().convertFrom(value, targetType, genericType, out, context)) {
                    return out.getValue();
                }
                if (!superType.isAssignableFrom(sourceType) || !entry.getValue().convertTo(value, targetType, genericType, out, context)) continue;
                return out.getValue();
            }
            if (targetType.equals(Object.class)) {
                return value;
            }
            if (beanConverter.convertFrom(value, targetType, genericType, out, context)) {
                return out.getValue();
            }
            if (beanConverter.convertTo(value, targetType, genericType, out, context)) {
                return out.getValue();
            }
            if (value instanceof Valued) {
                return Converts.convert(((Valued)value).getValue(), targetType, genericType);
            }
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConvertException(Strings.format("Error converting '{0}' to '{1}', value : {2}", sourceType.getName(), targetType.getName(), value), e);
        }
        return NOT_CONVERTED;
    }

    public static int toInt(Object value) {
        return null == value ? 0 : Converts.convert(value, Integer.class);
    }

    public static long toLong(Object value) {
        return null == value ? 0L : Converts.convert(value, Long.class);
    }

    public static boolean toBoolean(Object value) {
        return null == value || value instanceof String && value.equals("") ? false : Converts.convert(value, Boolean.class);
    }

    public static boolean toBoolean(String stringValue, boolean defaultValue) {
        return Strings.isEmpty(stringValue) ? defaultValue : Converts.convert(stringValue, Boolean.class);
    }

    public static <T> T toBean(Map<String, ?> map, Class<T> beanClass) {
        Out<Object> out = new Out<Object>();
        try {
            beanConverter.convertFrom(map, beanClass, null, out, null);
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConvertException(Strings.format("Error converting map to bean '{0}'", beanClass.getName()), e);
        }
        return (T)out.getValue();
    }

    public static String toString(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof StringConvertibleTo) {
            return ((StringConvertibleTo)value).convertToString();
        }
        if (value instanceof byte[]) {
            return Strings.newStringUtf8((byte[])value);
        }
        Class<?> sourceType = value.getClass();
        try {
            Converter converter = Converts.findConverter(sourceType);
            if (null != converter) {
                return converter.convertToString(value);
            }
            if (value.getClass().isArray()) {
                StringBuilder string = new StringBuilder();
                for (int i = 0; i < Array.getLength(value); ++i) {
                    if (i > 0) {
                        string.append(',');
                    }
                    string.append(Converts.toString(Array.get(value, i)));
                }
                return string.toString();
            }
            if (value instanceof Iterable) {
                return Strings.join((Iterable)value, ",");
            }
            if (value instanceof Clob) {
                Clob clob = (Clob)value;
                return clob.getSubString(1L, (int)clob.length());
            }
            return value.toString();
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConvertException(Strings.format("Error converting '{0}' to String", sourceType.getName()), e);
        }
    }

    public static <E> List<E> toList(Class<E> elementType, Object value) {
        if (null == (value = Converts.trimToNull(value))) {
            return null;
        }
        try {
            if (value instanceof String) {
                return (List)listConverter.toCollection(List.class, elementType, (String)value);
            }
            if (value instanceof Iterable) {
                return (List)listConverter.toCollection(List.class, elementType, (Iterable)value, null);
            }
            if (value.getClass().isArray()) {
                return (List)listConverter.toCollectionFromArray(List.class, elementType, value, null);
            }
        }
        catch (ConvertException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ConvertException(Strings.format("Error converting '{0}' to List, value : {1}", value.getClass().getName(), value), e);
        }
        throw new ConvertUnsupportedException(Strings.format("Cannot convert '{0}' to List, value : {1}", value.getClass().getName(), value.toString()));
    }

    public static Object[] toObjectArray(Object arrayObject) throws IllegalStateException {
        if (null == arrayObject) {
            return null;
        }
        Class<?> cls = arrayObject.getClass();
        if (!cls.isArray()) {
            throw new IllegalStateException("the given object is not an array");
        }
        if (arrayObject instanceof Object[]) {
            return (Object[])arrayObject;
        }
        Class<?> compoenetType = Primitives.wrap(cls.getComponentType());
        Object[] objectArray = new Object[Array.getLength(arrayObject)];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Converts.convert(Array.get(arrayObject, i), compoenetType);
        }
        return objectArray;
    }

    static <T> T toPrimitive(Object value, Class<T> targetType) {
        if (null == value) {
            return (T)Classes.getDefaultValue(targetType);
        }
        return Converts.convert(value, Primitives.wrap(targetType));
    }

    static Converter findConverter(Class<?> type) {
        Converter<?> converter = converters.get(type);
        if (null == converter) {
            if (type.isArray()) {
                return arrayConverter;
            }
            if (type.isEnum()) {
                return enumConverter;
            }
            for (Map.Entry<Class<?>, Converter> entry : assignableFromConverters.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                return entry.getValue();
            }
        }
        return converter;
    }

    static Object trimToNull(Object value) {
        if (null == value) {
            return null;
        }
        if (Null.is(value)) {
            return null;
        }
        if (value instanceof String) {
            return Strings.trimToNull((String)value);
        }
        return value;
    }

    static {
        Converts.register(String.class, new StringConverter());
        Converts.register(Character.class, new CharacterConverter());
        Converts.register(Boolean.class, new BooleanConverter());
        Converts.register(Byte.class, new NumberConverters.ByteConverter());
        Converts.register(Short.class, new NumberConverters.ShortConverter());
        Converts.register(Integer.class, new NumberConverters.IntegerConverter());
        Converts.register(Long.class, new NumberConverters.LongConverter());
        Converts.register(Float.class, new NumberConverters.FloatConverter());
        Converts.register(Double.class, new NumberConverters.DoubleConverter());
        Converts.register(BigInteger.class, new NumberConverters.BigIntegerConverter());
        Converts.register(BigDecimal.class, new NumberConverters.BigDecimalConverter());
        Converts.register(java.util.Date.class, new DateTimeConverters.DateTimeConverter());
        Converts.register(Date.class, new DateTimeConverters.SqlDateConverter());
        Converts.register(Timestamp.class, new DateTimeConverters.SqlTimestampConverter());
        Converts.register(Time.class, new DateTimeConverters.SqlTimeConverter());
        Converts.register(Calendar.class, new DateTimeConverters.CalendarConverter());
        Converts.register(LocalDate.class, new DateTimeConverters.LocalDateConverter());
        Converts.register(LocalTime.class, new DateTimeConverters.LocalTimeConverter());
        Converts.register(LocalDateTime.class, new DateTimeConverters.LocalDateTimeConverter());
        Converts.register(Iterable.class, new CollectionConverters.ListConverter());
        Converts.register(Collection.class, new CollectionConverters.ListConverter());
        Converts.register(List.class, listConverter);
        Converts.register(Set.class, new CollectionConverters.SetConverter());
        Converts.register(Map.class, new MapConverter());
        Converts.register(Class.class, new ClassConverter());
        Converts.register(Method.class, new MethodConverter());
        Converts.register(Locale.class, new LocaleConverter());
        Converts.register(Charset.class, new CharsetConverter());
        Converts.registerAssignableFrom(Clob.class, new ClobConverter());
        Converts.registerAssignableFrom(Blob.class, new BlobConverter());
        Converts.registerAssignableFrom(InputStream.class, new InputStreamConverter());
        Converts.register(MSimpleType.class, new MSimpleType.MSimpleTypeConverter());
    }
}

