/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import leap.lang.DateTimes;
import leap.lang.convert.AbstractDateConverter;
import leap.lang.convert.AbstractDateTimeConverter;
import leap.lang.convert.Converter;
import leap.lang.time.DateFormats;

public class DateTimeConverters {
    protected DateTimeConverters() {
    }

    public static class InstantConverter
    extends AbstractDateConverter<Instant> {
        @Override
        protected Instant convertFrom(Class<?> targetType, java.util.Date date) {
            return null;
        }

        @Override
        protected Instant convertFrom(Class<?> targetType, Calendar calendar) {
            return null;
        }

        @Override
        protected Instant convertFrom(Class<?> targetType, Long time) {
            return null;
        }
    }

    public static class SqlTimestampConverter
    extends AbstractDateConverter<Timestamp> {
        public SqlTimestampConverter() {
            this.patterns = DateFormats.DEFAULT_PATTERNS;
        }

        @Override
        protected Timestamp convertFrom(Class<?> targetType, Calendar calendar) {
            return new Timestamp(calendar.getTimeInMillis());
        }

        @Override
        protected Timestamp convertFrom(Class<?> targetType, java.util.Date date) {
            return new Timestamp(date.getTime());
        }

        @Override
        protected Timestamp convertFrom(Class<?> targetType, Long time) {
            return new Timestamp(time);
        }
    }

    public static class SqlTimeConverter
    extends AbstractDateConverter<Time> {
        public SqlTimeConverter() {
            this.patterns = DateFormats.DEFAULT_PATTERNS;
        }

        @Override
        protected Time convertFrom(Class<?> targetType, Calendar calendar) {
            return new Time(calendar.getTimeInMillis());
        }

        @Override
        protected Time convertFrom(Class<?> targetType, java.util.Date date) {
            return new Time(date.getTime());
        }

        @Override
        protected Time convertFrom(Class<?> targetType, Long time) {
            return new Time(time);
        }
    }

    public static class SqlDateConverter
    extends AbstractDateConverter<Date> {
        public SqlDateConverter() {
            this.patterns = DateFormats.DEFAULT_PATTERNS;
        }

        @Override
        protected Date convertFrom(Class<?> targetType, Calendar calendar) {
            return new Date(calendar.getTimeInMillis());
        }

        @Override
        protected Date convertFrom(Class<?> targetType, java.util.Date date) {
            return new Date(date.getTime());
        }

        @Override
        protected Date convertFrom(Class<?> targetType, Long time) {
            return new Date(time);
        }
    }

    public static class CalendarConverter
    extends AbstractDateConverter<Calendar>
    implements Converter<Calendar> {
        public CalendarConverter() {
            this.patterns = DateFormats.DEFAULT_PATTERNS;
        }

        @Override
        protected Calendar convertFrom(Class<?> targetType, java.util.Date date) {
            Calendar c = Calendar.getInstance();
            c.setTime(date);
            return c;
        }

        @Override
        protected Calendar convertFrom(Class<?> targetType, Calendar calendar) {
            return calendar;
        }

        @Override
        protected Calendar convertFrom(Class<?> targetType, Long time) {
            Calendar c = Calendar.getInstance();
            c.setTime(new java.util.Date(time));
            return c;
        }
    }

    public static class DateTimeConverter
    extends AbstractDateConverter<java.util.Date>
    implements Converter<java.util.Date> {
        public DateTimeConverter() {
            this.patterns = DateFormats.DEFAULT_PATTERNS;
        }

        @Override
        protected java.util.Date convertFrom(Class<?> targetType, java.util.Date date) {
            return date;
        }

        @Override
        protected java.util.Date convertFrom(Class<?> targetType, Calendar calendar) {
            return new java.util.Date(calendar.getTimeInMillis());
        }

        @Override
        protected java.util.Date convertFrom(Class<?> targetType, Long time) {
            return new java.util.Date(time);
        }
    }

    public static class LocalDateTimeConverter
    extends AbstractDateTimeConverter<LocalDateTime> {
        @Override
        public String convertToString(LocalDateTime value) throws Throwable {
            return value.toString();
        }

        @Override
        protected LocalDateTime convertFromString(CharSequence cs) {
            return DateTimes.tryParseLocalDateTime(cs);
        }

        @Override
        protected Instant convertToInstant(LocalDateTime value) {
            return value.toInstant(ZoneOffset.UTC);
        }

        @Override
        protected LocalDateTime convertFromInstant(Instant instant) {
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        }
    }

    public static class LocalTimeConverter
    extends AbstractDateTimeConverter<LocalTime> {
        @Override
        public String convertToString(LocalTime value) throws Throwable {
            return value.toString();
        }

        @Override
        protected LocalTime convertFromString(CharSequence cs) {
            return DateTimes.tryParseLocalTime(cs);
        }

        @Override
        protected Instant convertToInstant(LocalTime value) {
            return null;
        }

        @Override
        protected LocalTime convertFromInstant(Instant instant) {
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalTime();
        }
    }

    public static class LocalDateConverter
    extends AbstractDateTimeConverter<LocalDate> {
        @Override
        public String convertToString(LocalDate value) throws Throwable {
            return value.format(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        @Override
        protected LocalDate convertFromString(CharSequence cs) {
            return DateTimes.tryParseLocalDate(cs);
        }

        @Override
        protected Instant convertToInstant(LocalDate value) {
            return Instant.ofEpochMilli(value.toEpochDay());
        }

        @Override
        protected LocalDate convertFromInstant(Instant instant) {
            return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
        }
    }
}

