/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import leap.lang.Enums;
import leap.lang.Out;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converter;
import leap.lang.convert.Converts;

public class EnumConverter
extends AbstractConverter<Enum<?>>
implements Converter<Enum<?>> {
    public boolean convertFrom(Object value, Class<?> targetType, Class<?> genericType, Out<Object> out, ConvertContext context) throws Throwable {
        Object enumObject = Enums.valueOf(targetType, value);
        if (null != enumObject) {
            out.set(enumObject);
            return true;
        }
        return false;
    }

    @Override
    public boolean convertTo(Enum<?> value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        Object realValue = Enums.getValue(value);
        out.set(Converts.convert(realValue, targetType, genericType));
        return true;
    }

    @Override
    public String convertToString(Enum<?> value) throws Throwable {
        Object realValue = Enums.getValue(value);
        return Converts.toString(realValue);
    }
}

