/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Type;
import leap.lang.Charsets;
import leap.lang.Out;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;
import leap.lang.io.IO;

public class InputStreamConverter
extends AbstractConverter<InputStream> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof byte[]) {
            out.set(new ByteArrayInputStream((byte[])value));
            return true;
        }
        return false;
    }

    @Override
    public boolean convertTo(InputStream value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        byte[] data = IO.readByteArray(value);
        out.set(Converts.convert((Object)data, targetType, genericType));
        return true;
    }

    @Override
    public String convertToString(InputStream value) throws Throwable {
        return IO.readString(value, Charsets.UTF_8);
    }
}

