/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import leap.lang.Out;
import leap.lang.Types;
import leap.lang.convert.AbstractConverter;
import leap.lang.convert.ConvertContext;
import leap.lang.convert.Converts;
import leap.lang.reflect.Reflection;

public class MapConverter
extends AbstractConverter<Map> {
    @Override
    public boolean convertFrom(Object value, Class<?> targetType, Type genericType, Out<Object> out, ConvertContext context) throws Throwable {
        if (value instanceof Map) {
            Map map = (Map)value;
            if (null == genericType) {
                out.set(value);
                return true;
            }
            Class<?>[] actualTypeArguments = Types.getActualTypeArguments(genericType);
            Class<?> keyType = actualTypeArguments[0];
            Class<?> valType = actualTypeArguments[1];
            Map targetMap = this.createMap(targetType);
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                Object key = Converts.convert(entry.getKey(), keyType, context);
                Object val = Converts.convert(entry.getValue(), valType, context);
                targetMap.put(key, val);
            }
            out.set(targetMap);
            return true;
        }
        return false;
    }

    protected Map createMap(Class<?> mapType) {
        if (mapType.equals(Map.class)) {
            return new LinkedHashMap();
        }
        return (Map)Reflection.newInstance(mapType);
    }
}

