/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import leap.lang.Strings;
import leap.lang.convert.AbstractNumberConverter;
import leap.lang.convert.ConvertException;

public class NumberConverters {

    public static class LongConverter
    extends AbstractNumberConverter<Long> {
        @Override
        protected Long toNumber(Class<?> targetType, Number number) {
            return number.longValue();
        }

        @Override
        protected Long toNumber(Class<?> targetType, Object value) {
            if (value instanceof Date) {
                return this.toNumber((Class)targetType, (Number)((Date)value).getTime());
            }
            if (value instanceof Calendar) {
                return this.toNumber((Class)targetType, (Object)((Calendar)value).getTime());
            }
            return (Long)super.toNumber(targetType, value);
        }

        @Override
        protected Long toNumber(Class<?> targetType, String stringValue) {
            return Long.valueOf(stringValue);
        }
    }

    public static class ShortConverter
    extends AbstractNumberConverter<Short> {
        @Override
        protected Short toNumber(Class<?> targetType, Number number) {
            long longValue = number.longValue();
            if (longValue > 32767L) {
                throw new ConvertException(Strings.format("value '{0}' is too large for type '{1}'", longValue, targetType.getName()));
            }
            if (longValue < -32768L) {
                throw new ConvertException(Strings.format("value '{0}' is too small for type '{1}'", longValue, targetType.getName()));
            }
            return number.shortValue();
        }

        @Override
        protected Short toNumber(Class<?> targetType, String stringValue) {
            return Short.valueOf(stringValue);
        }
    }

    public static class IntegerConverter
    extends AbstractNumberConverter<Integer> {
        @Override
        protected Integer toNumber(Class<?> targetType, Number number) {
            long longValue = number.longValue();
            if (longValue > Integer.MAX_VALUE) {
                throw new ConvertException(Strings.format("value '{0}' is too large for type '{1}'", longValue, targetType.getName()));
            }
            if (longValue < Integer.MIN_VALUE) {
                throw new ConvertException(Strings.format("value '{0}' is too small for type '{1}'", longValue, targetType.getName()));
            }
            return number.intValue();
        }

        @Override
        protected Integer toNumber(Class<?> targetType, String stringValue) {
            return Integer.valueOf(stringValue);
        }
    }

    public static class BigIntegerConverter
    extends AbstractNumberConverter<BigInteger> {
        @Override
        protected BigInteger toNumber(Class<?> targetType, Number number) {
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).toBigInteger();
            }
            return BigInteger.valueOf(number.longValue());
        }

        @Override
        protected BigInteger toNumber(Class<?> targetType, String stringValue) {
            return new BigInteger(stringValue);
        }
    }

    public static class BigDecimalConverter
    extends AbstractNumberConverter<BigDecimal> {
        @Override
        protected BigDecimal toNumber(Class<?> targetType, Number number) {
            if (number instanceof Float || number instanceof Double) {
                return new BigDecimal(number.toString());
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            return BigDecimal.valueOf(number.longValue());
        }

        @Override
        protected BigDecimal toNumber(Class<?> targetType, String stringValue) {
            return new BigDecimal(stringValue);
        }
    }

    public static class DoubleConverter
    extends AbstractNumberConverter<Double> {
        @Override
        protected Double toNumber(Class<?> targetType, Number number) {
            return number.doubleValue();
        }

        @Override
        protected Double toNumber(Class<?> targetType, String stringValue) {
            return Double.valueOf(stringValue);
        }
    }

    public static class FloatConverter
    extends AbstractNumberConverter<Float> {
        @Override
        protected Float toNumber(Class<?> targetType, Number number) {
            double doubleValue = number.doubleValue();
            if (doubleValue > 3.4028234663852886E38) {
                throw new ConvertException(Strings.format("value '{0}' is too large for type '{1}'", doubleValue, targetType.getName()));
            }
            return Float.valueOf(number.floatValue());
        }

        @Override
        protected Float toNumber(Class<?> targetType, String stringValue) {
            return Float.valueOf(stringValue);
        }
    }

    public static class ByteConverter
    extends AbstractNumberConverter<Byte> {
        @Override
        protected Byte toNumber(Class<?> targetType, Number number) {
            long longValue = number.longValue();
            if (longValue > 127L) {
                throw new ConvertException(Strings.format("value '{0}' is too large for type '{1}'", longValue, targetType.getName()));
            }
            if (longValue < -128L) {
                throw new ConvertException(Strings.format("value '{0}' is too small for type '{1}'", longValue, targetType.getName()));
            }
            return number.byteValue();
        }

        @Override
        protected Byte toNumber(Class<?> targetType, String stringValue) {
            return Byte.valueOf(stringValue);
        }
    }
}

