/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.css;

import leap.lang.path.Paths;

public class CssUrlRewriter {
    private static final byte EOI = 26;
    protected final String path;
    protected final String css;
    protected final StringBuilder chars;
    private int mark;
    private int end;
    private int pos;
    private char ch;
    private boolean rewrited;

    public CssUrlRewriter(String path, String css) {
        this.path = Paths.suffixWithSlash(path);
        this.css = css;
        this.chars = new StringBuilder(css);
        this.end = this.chars.length() - 1;
        this.pos = -1;
    }

    public boolean tryRewrite() {
        while (this.next()) {
            if (this.ch == '@') {
                if (!this.scanLetters("import")) continue;
                this.rewriteImportUrl();
                continue;
            }
            if (this.ch != ':' || !this.scanUrlProperty()) continue;
            this.rewritePropertyUrl();
        }
        return this.rewrited;
    }

    public String rewrite() {
        if (this.tryRewrite()) {
            return this.chars.toString();
        }
        return this.css;
    }

    private boolean scanUrlProperty() {
        while (this.next()) {
            if (Character.isWhitespace(this.ch)) continue;
            return (this.ch == 'u' || this.ch == 'U') && this.scanUrlStart();
        }
        return false;
    }

    private void rewriteImportUrl() {
        do {
            if (Character.isWhitespace(this.ch)) continue;
            if (this.ch == '\'' || this.ch == '\"') {
                this.rewriteQuotedUri(this.ch);
                return;
            }
            if ((this.ch == 'u' || this.ch == 'U') && this.scanUrlStart()) {
                this.rewritePropertyUrl();
                return;
            }
            this.rewriteUnQuotedUri();
            return;
        } while (this.next());
    }

    private boolean scanUrlStart() {
        if (this.next() && (this.ch == 'r' || this.ch == 'R') && this.next() && (this.ch == 'l' || this.ch == 'L')) {
            while (this.next()) {
                if (Character.isWhitespace(this.ch)) continue;
                return this.ch == '(';
            }
        }
        return false;
    }

    private void rewriteUnQuotedUri() {
        this.mark();
        while (this.next()) {
            if (!Character.isWhitespace(this.ch)) continue;
            this.rewriteUrl(this.marked());
            break;
        }
    }

    private void rewriteQuotedUri(char quoteChar) {
        if (this.next()) {
            this.mark();
            do {
                if (this.ch != quoteChar) continue;
                this.rewriteUrl(this.marked());
                break;
            } while (this.next());
        }
    }

    private void rewritePropertyUrl() {
        if (this.next()) {
            this.mark();
            do {
                if (this.ch != ')') continue;
                this.rewriteUrl(this.marked());
                return;
            } while (this.next());
        }
    }

    private void rewriteUrl(String url) {
        char ch;
        if (url.length() == 0) {
            return;
        }
        char c = url.charAt(0);
        if (c == '/') {
            return;
        }
        for (int i = 1; i < url.length() && (ch = url.charAt(i)) != '/'; ++i) {
            if (ch != ':') continue;
            return;
        }
        String quoteChar = "";
        String urlPath = url.trim();
        if (c == '\"') {
            quoteChar = "\"";
            if (url.endsWith("\"")) {
                urlPath = url.substring(1, url.length() - 1);
            } else {
                return;
            }
        }
        if (c == '\'') {
            quoteChar = "'";
            if (url.endsWith("'")) {
                urlPath = url.substring(1, url.length() - 1);
            } else {
                return;
            }
        }
        String newUrl = quoteChar + this.path(Paths.normalize(Paths.applyRelative(this.path, urlPath))) + quoteChar;
        this.chars.replace(this.mark, this.pos, newUrl);
        int increse = newUrl.length() - url.length();
        this.pos += increse;
        this.end += increse;
        this.rewrited = true;
    }

    protected String path(String rewritedPath) {
        return rewritedPath;
    }

    private boolean scanLetters(String word) {
        if (this.next()) {
            this.mark();
            while (Character.isLetter(this.ch) && this.next()) {
            }
        }
        if (this.mark == this.pos || this.markedLen() > word.length()) {
            return false;
        }
        return word.equalsIgnoreCase(this.marked());
    }

    private void mark() {
        this.mark = this.pos;
    }

    private int markedLen() {
        return this.pos - this.mark;
    }

    private String marked() {
        return this.chars.substring(this.mark, this.pos);
    }

    private boolean next() {
        if (this.pos == this.end) {
            this.ch = (char)26;
            return false;
        }
        ++this.pos;
        this.ch = this.chars.charAt(this.pos);
        return true;
    }
}

