/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.csv;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import leap.lang.Args;
import leap.lang.Exceptions;
import leap.lang.csv.CSVFormat;
import leap.lang.csv.CSVParser;
import leap.lang.csv.CSVPrinter;
import leap.lang.csv.CsvProcessor;
import leap.lang.enums.CaseType;
import leap.lang.exception.NestedIOException;
import leap.lang.io.IO;
import leap.lang.resource.Resource;
import leap.lang.resource.Resources;

public class CSV {
    private static final CSVFormat DEFAULT_FORMAT = CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(true);
    private static final CSVFormat DEFAULT_FORMAT_SKIP_HEADER = DEFAULT_FORMAT.withSkipHeaderRecord(true);

    public static List<String[]> read(Reader reader) throws NestedIOException {
        return CSV.readList(reader, DEFAULT_FORMAT);
    }

    public static List<String[]> readSkipHeader(Reader reader) {
        return CSV.readList(reader, DEFAULT_FORMAT_SKIP_HEADER);
    }

    protected static List<String[]> readList(Reader reader, CSVFormat format) throws NestedIOException {
        Args.notNull(reader, "reader");
        CSVParser parser = null;
        try {
            parser = new CSVParser(reader, format);
            List<String[]> list = parser.getRecords1();
            return list;
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        finally {
            IO.close(reader);
            IO.close(parser);
        }
    }

    public static void read(Reader reader, CsvProcessor processor) throws NestedIOException {
        CSVParser parser = null;
        try {
            String[] row;
            parser = new CSVParser(reader, DEFAULT_FORMAT);
            int rownum = 0;
            while ((row = parser.nextRecord1()) != null) {
                processor.process(++rownum, row);
            }
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
        finally {
            IO.close(reader);
            IO.close(parser);
        }
    }

    public static void write(Writer writer, List<Object[]> rows) throws NestedIOException {
        CSVPrinter printer = null;
        try {
            printer = new CSVPrinter(writer, CSVFormat.DEFAULT);
            for (Object[] row : rows) {
                printer.printRecord(row);
            }
        }
        catch (IOException e) {
            throw Exceptions.wrap(e);
        }
        finally {
            IO.close(writer);
            IO.close(printer);
        }
    }

    public static List<String[]> decode(String csv) {
        return CSV.read(new StringReader(csv));
    }

    public static String encode(List<Object[]> rows) {
        StringWriter sw = new StringWriter();
        CSV.write(sw, rows);
        return sw.toString();
    }

    public static Map<String, String> readMapFromResources(String location, CaseType toCase, boolean skipHeader) {
        return CSV.readMapFromResources(new String[]{location}, toCase, skipHeader);
    }

    public static Map<String, String> readMapFromResources(String[] locations, CaseType toCase, boolean skipHeader) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        CSV.readMapFromResources(map, locations, toCase, skipHeader);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readMapFromResources(final Map<String, String> map, String[] locations, CaseType toCase, final boolean skipHeader) {
        if (null == toCase) {
            toCase = CaseType.ORIGINAL;
        }
        final CaseType finalCase = toCase;
        for (Resource resource : Resources.scan(locations)) {
            if (!resource.exists()) continue;
            InputStreamReader reader = null;
            try {
                reader = resource.getInputStreamReader();
                CSV.read(reader, new CsvProcessor(){

                    @Override
                    public void process(int rownum, String[] values) throws Exception {
                        if (rownum == 1 && skipHeader) {
                            return;
                        }
                        String singular = finalCase.get(values[0]);
                        String plural = finalCase.get(values[1]);
                        map.put(singular, plural);
                        map.put(plural, singular);
                    }
                });
            }
            finally {
                IO.close(reader);
            }
        }
    }

    protected CSV() {
    }
}

