/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.csv;

import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import leap.lang.Args;
import leap.lang.csv.CSVFormat;
import leap.lang.csv.CSVRecord;
import leap.lang.csv.ExtendedBufferedReader;
import leap.lang.csv.Lexer;
import leap.lang.csv.Token;

final class CSVParser
implements Iterable<CSVRecord>,
Closeable {
    private final CSVFormat format;
    private final Map<String, Integer> headerMap;
    private final Lexer lexer;
    private final List<String> record = new ArrayList<String>();
    private boolean readComment = true;
    private String recordComment;
    private long recordNumber;
    private final Token reusableToken = new Token();

    public static CSVParser parse(File file, CSVFormat format) throws IOException {
        Args.notNull(file, "file");
        Args.notNull(format, "format");
        return new CSVParser(new FileReader(file), format);
    }

    public static CSVParser parse(String string, CSVFormat format) throws IOException {
        Args.notNull(string, "string");
        Args.notNull(format, "format");
        return new CSVParser(new StringReader(string), format);
    }

    public static CSVParser parse(URL url, Charset charset, CSVFormat format) throws IOException {
        Args.notNull(url, "url");
        Args.notNull(charset, "charset");
        Args.notNull(format, "format");
        return new CSVParser(new InputStreamReader(url.openStream(), charset == null ? Charset.forName("UTF-8") : charset), format);
    }

    public CSVParser(Reader reader, CSVFormat format) throws IOException {
        Args.notNull(reader, "reader");
        Args.notNull(format, "format");
        format.validate();
        this.format = format;
        this.lexer = new Lexer(format, new ExtendedBufferedReader(reader));
        this.headerMap = this.initializeHeader();
    }

    private void addRecordValue() {
        String input = this.reusableToken.content.toString();
        String nullString = this.format.getNullString();
        if (nullString == null) {
            this.record.add(input);
        } else {
            this.record.add(input.equalsIgnoreCase(nullString) ? null : input);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.lexer != null) {
            this.lexer.close();
        }
    }

    public long getCurrentLineNumber() {
        return this.lexer.getCurrentLineNumber();
    }

    public Map<String, Integer> getHeaderMap() {
        return new LinkedHashMap<String, Integer>(this.headerMap);
    }

    public long getRecordNumber() {
        return this.recordNumber;
    }

    public List<CSVRecord> getRecords() throws IOException {
        CSVRecord rec;
        ArrayList<CSVRecord> records = new ArrayList<CSVRecord>();
        while ((rec = this.nextRecord()) != null) {
            records.add(rec);
        }
        return records;
    }

    List<String[]> getRecords1() throws IOException {
        String[] rec;
        ArrayList<String[]> records = new ArrayList<String[]>();
        while ((rec = this.nextRecord1()) != null) {
            records.add(rec);
        }
        return records;
    }

    private Map<String, Integer> initializeHeader() throws IOException {
        LinkedHashMap<String, Integer> hdrMap = null;
        String[] formatHeader = this.format.getHeader();
        if (formatHeader != null) {
            hdrMap = new LinkedHashMap<String, Integer>();
            String[] header = null;
            if (formatHeader.length == 0) {
                CSVRecord record = this.nextRecord();
                if (record != null) {
                    header = record.values();
                }
            } else {
                if (this.format.getSkipHeaderRecord()) {
                    this.nextRecord();
                }
                header = formatHeader;
            }
            if (header != null) {
                for (int i = 0; i < header.length; ++i) {
                    hdrMap.put(header[i], i);
                }
            }
        }
        return hdrMap;
    }

    public boolean isClosed() {
        return this.lexer.isClosed();
    }

    @Override
    public Iterator<CSVRecord> iterator() {
        return new Iterator<CSVRecord>(){
            private CSVRecord current;

            private CSVRecord getNextRecord() {
                try {
                    return CSVParser.this.nextRecord();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                if (CSVParser.this.isClosed()) {
                    return false;
                }
                if (this.current == null) {
                    this.current = this.getNextRecord();
                }
                return this.current != null;
            }

            @Override
            public CSVRecord next() {
                if (CSVParser.this.isClosed()) {
                    throw new NoSuchElementException("CSVParser has been closed");
                }
                CSVRecord next = this.current;
                this.current = null;
                if (next == null && (next = this.getNextRecord()) == null) {
                    throw new NoSuchElementException("No more CSV records available");
                }
                return next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    CSVRecord nextRecord() throws IOException {
        if (this.tryNextRecord()) {
            return new CSVRecord(this.record.toArray(new String[this.record.size()]), this.headerMap, this.recordComment, this.recordNumber);
        }
        return null;
    }

    String[] nextRecord1() throws IOException {
        if (this.tryNextRecord()) {
            return this.record.toArray(new String[this.record.size()]);
        }
        return null;
    }

    boolean tryNextRecord() throws IOException {
        this.record.clear();
        this.recordComment = null;
        StringBuilder sb = null;
        do {
            this.reusableToken.reset();
            this.lexer.nextToken(this.reusableToken);
            switch (this.reusableToken.type) {
                case TOKEN: {
                    this.addRecordValue();
                    break;
                }
                case EORECORD: {
                    this.addRecordValue();
                    break;
                }
                case EOF: {
                    if (!this.reusableToken.isReady) break;
                    this.addRecordValue();
                    break;
                }
                case INVALID: {
                    throw new IOException("(line " + this.getCurrentLineNumber() + ") invalid parse sequence");
                }
                case COMMENT: {
                    if (this.readComment) {
                        if (sb == null) {
                            sb = new StringBuilder();
                        } else {
                            sb.append('\n');
                        }
                        sb.append((CharSequence)this.reusableToken.content);
                    }
                    this.reusableToken.type = Token.Type.TOKEN;
                }
            }
        } while (this.reusableToken.type == Token.Type.TOKEN);
        if (!this.record.isEmpty()) {
            ++this.recordNumber;
            this.recordComment = sb == null ? null : sb.toString();
            return true;
        }
        return false;
    }
}

