/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import leap.lang.Arrays2;
import leap.lang.Enumerable;
import leap.lang.Enumerables;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.el.AbstractElContext;
import leap.lang.el.ElBeanProperty;
import leap.lang.el.ElConstantField;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElFunction;
import leap.lang.el.ElInstanceField;
import leap.lang.el.ElInstanceMethod;
import leap.lang.el.ElMethod;
import leap.lang.el.ElProperty;
import leap.lang.el.ElStaticField;
import leap.lang.el.ElStaticMethod;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectField;
import leap.lang.reflect.ReflectMethod;

public abstract class AbstractElEvalContext
extends AbstractElContext
implements ElEvalContext {
    protected Object ctx;
    protected Map<String, Object> vars;
    protected Map<String, ElFunction> functions;
    private Map<Object, Enumerable<?>> arrays;

    public AbstractElEvalContext() {
        this(null);
    }

    public AbstractElEvalContext(Object ctx) {
        this.ctx = ctx;
        this.vars = new HashMap<String, Object>();
    }

    public AbstractElEvalContext(Object ctx, Map<String, Object> vars) {
        this.ctx = ctx;
        this.vars = null == vars ? new HashMap() : vars;
    }

    @Override
    public Object getRoot() {
        return this.ctx;
    }

    @Override
    public Object resolveVariable(String name) {
        Object v = this.vars.get(name);
        if (null == v && null != this.ctx && !this.vars.containsKey(name)) {
            v = this.resolveContextProperty(name);
        }
        return v;
    }

    @Override
    public boolean isVariableResolved(String name) {
        return this.vars.containsKey(name);
    }

    @Override
    public ElMethod resolveMethod(Object owner, Class<?> cls, String name, Object[] args) {
        return this.resolveMethod(cls, name, args);
    }

    @Override
    public ElMethod resolveMethod(Class<?> cls, String name, Object[] args) {
        ReflectClass rc = ReflectClass.of(cls);
        int len = args.length;
        for (ReflectMethod rm : rc.getMethods()) {
            if (!rm.getName().equals(name) || rm.getParameters().length != len) continue;
            boolean ok = true;
            for (int i = 0; i < len; ++i) {
                Object v = args[i];
                if (null == v || rm.getParameters()[i].getType().isAssignableFrom(v.getClass())) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return rm.isStatic() ? new ElStaticMethod(rm) : new ElInstanceMethod(rm);
        }
        return null;
    }

    @Override
    public ElProperty resolveProperty(Object owner, Class<?> cls, String name) {
        BeanType bt = BeanType.of(cls);
        BeanProperty bp = bt.tryGetProperty(name);
        if (null != bp) {
            return new ElBeanProperty(bp);
        }
        return this.resolveProperty(cls, name);
    }

    @Override
    public ElProperty resolveProperty(Class<?> cls, String name) {
        ReflectClass rc = ReflectClass.of(cls);
        ReflectField rf = rc.getField(name);
        if (null != rf && rf.isPublicGet()) {
            if (rf.isStatic()) {
                return rf.isFinal() ? ElConstantField.of(rf) : new ElStaticField(rf);
            }
            return new ElInstanceField(rf);
        }
        final ElMethod m = this.resolveMethod(cls, name, Arrays2.EMPTY_OBJECT_ARRAY);
        if (null != m) {
            return new ElProperty(){

                @Override
                public Object getValue(ElEvalContext context, Object instance) throws Throwable {
                    return m.invoke(context, instance, Arrays2.EMPTY_OBJECT_ARRAY);
                }
            };
        }
        return null;
    }

    @Override
    public ElFunction resolveFunction(String fullName) {
        return null == this.functions ? null : this.functions.get(fullName);
    }

    @Override
    public Object getArrayItem(Object a, int index) {
        return this.array(a).get(index);
    }

    public Map<String, ElFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Map<String, ElFunction> functions) {
        this.functions = functions;
    }

    protected Object resolveContextProperty(String name) {
        if (this.ctx instanceof Map) {
            Map map = (Map)this.ctx;
            if (map.containsKey(name)) {
                Object v = map.get(name);
                this.vars.put(name, v);
                return v;
            }
        } else {
            ElProperty p = this.resolveProperty(this.ctx.getClass(), name);
            if (null != p) {
                try {
                    Object v = p.getValue(this, this.ctx);
                    this.vars.put(name, v);
                    return v;
                }
                catch (Throwable e) {
                    throw new ElException("Error get value from property '" + name + "' in class '" + this.ctx.getClass() + "', " + e.getMessage(), e);
                }
            }
        }
        return null;
    }

    private Enumerable<?> array(Object a) {
        if (null == this.arrays) {
            this.arrays = new IdentityHashMap();
            Enumerable e = Enumerables.of(a);
            this.arrays.put(a, e);
            return e;
        }
        Enumerable<Object> e = this.arrays.get(a);
        if (null == e) {
            e = Enumerables.of(a);
            this.arrays.put(a, e);
        }
        return e;
    }
}

