/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import leap.lang.el.AbstractElContext;
import leap.lang.el.ElFunction;
import leap.lang.el.ElParseContext;

public abstract class AbstractElParseContext
extends AbstractElContext
implements ElParseContext {
    protected final List<String> pkgs = new ArrayList<String>();
    protected final Map<String, Object> vars = new HashMap<String, Object>();
    protected final Map<String, ElFunction> funcs = new HashMap<String, ElFunction>();
    private final List<String> pkgsImmutableView = Collections.unmodifiableList(this.pkgs);

    public AbstractElParseContext() {
        this(null, null);
    }

    public AbstractElParseContext(Map<String, ElFunction> funcs) {
        this(funcs, null);
    }

    public AbstractElParseContext(Map<String, ElFunction> funcs, Map<String, Object> vars) {
        if (null != funcs) {
            this.funcs.putAll(funcs);
        }
        if (null != vars) {
            this.vars.putAll(vars);
        }
    }

    @Override
    public List<String> getImportedPackages() {
        return this.pkgsImmutableView;
    }

    @Override
    public Object resolveVariable(String name) {
        return this.vars.get(name);
    }

    @Override
    public ElFunction resolveFunction(String fullname) {
        return this.funcs.get(fullname);
    }
}

