/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.el.ElFriendly;
import leap.lang.el.ElFunction;
import leap.lang.el.ElStaticMethod;
import leap.lang.el.ElStaticMethods;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectMethod;
import leap.lang.reflect.Reflection;

public class ElClasses {
    private static String fullName(String prefix, String name) {
        return Strings.isEmpty(prefix) ? name : prefix + ":" + name;
    }

    public static ElFunction createFunction(Class<?> cls, String methodNameOrDesc) {
        return new ElStaticMethod(Reflection.getMethodByNameOrDesc(cls, methodNameOrDesc));
    }

    public static Map<String, ElFunction> createFunctions(String prefix, Class<?> cls) {
        return ElClasses.createFunctions(prefix, cls, false);
    }

    public static Map<String, ElFunction> createFunctions(String prefix, Class<?> cls, boolean annotatedOnly) {
        ReflectClass rc = ReflectClass.of(cls);
        HashMap<String, ElFunction> funcs = new HashMap<String, ElFunction>();
        for (ReflectMethod m : rc.getMethods()) {
            if (!m.isPublic() || !m.isStatic() || annotatedOnly && !ElClasses.isElFriendly(m.getReflectedMethod())) continue;
            String fullName = ElClasses.fullName(prefix, m.getName());
            ElStaticMethods f = (ElStaticMethods)funcs.get(fullName);
            if (null == f) {
                f = new ElStaticMethods(cls, m.getName());
                funcs.put(fullName, f);
            }
            f.add(m);
        }
        return funcs;
    }

    public static boolean isElFriendly(Method m) {
        ElFriendly a = m.getAnnotation(ElFriendly.class);
        if (a != null && a.value()) {
            return true;
        }
        a = m.getDeclaringClass().getAnnotation(ElFriendly.class);
        return a == null || !a.value();
    }
}

