/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.util.Map;
import java.util.WeakHashMap;
import leap.lang.Args;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElProperty;
import leap.lang.reflect.ReflectField;

public class ElConstantField
implements ElProperty {
    private static final Object lock = new Object();
    private static final Map<Class<?>, Map<String, ElConstantField>> constants = new WeakHashMap();
    private final Object value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElConstantField of(ReflectField field) {
        if (!field.isFinal()) {
            return null;
        }
        Class<?> cls = field.getDeclaringClass();
        String name = field.getName();
        Object object = lock;
        synchronized (object) {
            ElConstantField f;
            Map<String, ElConstantField> cache = constants.get(cls);
            if (null == cache) {
                cache = new WeakHashMap<String, ElConstantField>();
                constants.put(cls, cache);
            }
            if (null == (f = cache.get(name))) {
                f = new ElConstantField(field);
                cache.put(name, f);
            }
            return f;
        }
    }

    private ElConstantField(ReflectField field) {
        Args.assertTrue(field.isStatic() && field.isFinal(), "Must be static final field");
        this.value = field.getValue(null);
    }

    @Override
    public Object getValue(ElEvalContext context, Object instance) throws Throwable {
        return this.value;
    }
}

