/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.lang.reflect.Method;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElFunction;
import leap.lang.el.ElMethod;
import leap.lang.reflect.ReflectClass;
import leap.lang.reflect.ReflectMethod;

public class ElInstanceMethod
implements ElFunction,
ElMethod {
    protected final Object instance;
    protected final ReflectMethod m;
    protected final int size;

    public ElInstanceMethod(ReflectMethod m) {
        this(m, null);
    }

    public ElInstanceMethod(Method m) {
        this(m, null);
    }

    public ElInstanceMethod(ReflectMethod m, Object instance) {
        this.m = m;
        this.size = m.getReflectedMethod().isVarArgs() ? -1 : m.getParameters().length;
        this.instance = instance;
    }

    public ElInstanceMethod(Method m, Object instance) {
        this.m = ReflectClass.of(m.getDeclaringClass()).getMethod(m);
        this.size = m.isVarArgs() ? -1 : m.getParameterTypes().length;
        this.instance = instance;
    }

    @Override
    public int getArgumentSize() {
        return this.size;
    }

    @Override
    public Object invoke(ElEvalContext context, Object instance, Object[] args) throws Throwable {
        return this.m.invoke(instance, args);
    }

    @Override
    public Object invoke(ElEvalContext context, Object[] args) throws Throwable {
        if (null == this.instance) {
            throw new IllegalStateException("Instance is null,cannot invoke method '" + this.m.getName() + "'");
        }
        return this.m.invoke(this.instance, args);
    }
}

