/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.util.HashMap;
import java.util.Map;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElFunction;
import leap.lang.el.ElMethod;
import leap.lang.reflect.ReflectMethod;

public class ElInstanceMethods
implements ElFunction,
ElMethod {
    protected Object instance;
    protected Class<?> cls;
    protected String name;
    protected Map<Integer, ReflectMethod> methods;
    protected ReflectMethod defaultMethod;

    public ElInstanceMethods(Class<?> cls, String name) {
        this.cls = cls;
        this.name = name;
    }

    public ElInstanceMethods(Class<?> cls, String name, Object instance) {
        this.cls = cls;
        this.name = name;
        this.instance = instance;
    }

    @Override
    public int getArgumentSize() {
        return -1;
    }

    public ElInstanceMethods add(ReflectMethod m) {
        if (!m.getName().equals(this.name)) {
            throw new IllegalArgumentException("Method name '" + m.getName() + "' must be '" + this.name + "'");
        }
        if (m.getReflectedMethod().isVarArgs()) {
            this.defaultMethod = m;
        } else {
            Integer i = m.getParameters().length;
            if (!this.methods().containsKey(i)) {
                this.methods().put(i, m);
            }
        }
        return this;
    }

    @Override
    public Object invoke(ElEvalContext context, Object instance, Object[] args) throws Throwable {
        ReflectMethod m;
        ReflectMethod reflectMethod = m = null == this.methods ? null : this.methods.get(args.length);
        if (null == m) {
            m = this.defaultMethod;
        }
        if (null == m) {
            throw new ElException("Invalid argument size '" + args.length + "' for invoking method '" + this.name + "' in class '" + this.cls.getName() + "'");
        }
        return this.invoke(m, instance, args);
    }

    @Override
    public Object invoke(ElEvalContext context, Object[] args) throws Throwable {
        return this.invoke(context, this.instance, args);
    }

    protected Object invoke(ReflectMethod m, Object owner, Object[] args) throws Throwable {
        if (null == this.instance) {
            throw new ElException("Cannot invoke instance method '" + this.name + "', the instance is null");
        }
        return m.invoke(owner, args);
    }

    protected Map<Integer, ReflectMethod> methods() {
        if (null == this.methods) {
            this.methods = new HashMap<Integer, ReflectMethod>();
        }
        return this.methods;
    }
}

