/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class ElTypes {
    public static final int UNRESOLVED = -1;
    public static final int OBJECT = 0;
    public static final int COLLECTION = 1;
    public static final int ENUM = 2;
    public static final int STRING = 10;
    public static final int BOOLEAN = 20;
    public static final int W_BOOLEAN = 21;
    public static final int CHAR = 30;
    public static final int W_CHAR = 31;
    public static final int BYTE = 40;
    public static final int W_BYTE = 41;
    public static final int SHORT = 50;
    public static final int INTEGER = 51;
    public static final int LONG = 52;
    public static final int W_SHORT = 53;
    public static final int W_INTEGER = 54;
    public static final int W_LONG = 55;
    public static final int FLOAT = 60;
    public static final int DOUBLE = 61;
    public static final int W_FLOAT = 62;
    public static final int W_DOUBLE = 63;
    public static final int BIG_DECIMAL = 70;
    public static final int BIG_INTEGER = 71;
    private static final Map<Class<?>, Integer> typeCodes = new HashMap(30, 0.5f);

    public static boolean isFloatOrDouble(int type) {
        return type > 59 & type < 70;
    }

    public static boolean isShortIntOrLong(int type) {
        return type > 49 && type < 60;
    }

    public static boolean isBoolean(int type) {
        return type == 21 || type == 20;
    }

    public static int resolveTypeByVal(Object v) {
        if (null == v) {
            return 0;
        }
        return ElTypes.resolveType(v.getClass());
    }

    public static int resolveType(Class<?> cls) {
        if (null == cls) {
            return -1;
        }
        Integer code = typeCodes.get(cls);
        if (code == null) {
            if (null != cls) {
                if (Collection.class.isAssignableFrom(cls)) {
                    return 1;
                }
                if (cls.isEnum()) {
                    return 2;
                }
            }
            return 0;
        }
        return code;
    }

    static {
        typeCodes.put(Integer.class, 54);
        typeCodes.put(Double.class, 63);
        typeCodes.put(Boolean.class, 21);
        typeCodes.put(String.class, 10);
        typeCodes.put(Long.class, 55);
        typeCodes.put(Short.class, 53);
        typeCodes.put(Float.class, 62);
        typeCodes.put(Byte.class, 41);
        typeCodes.put(Character.class, 31);
        typeCodes.put(BigDecimal.class, 70);
        typeCodes.put(BigInteger.class, 71);
        typeCodes.put(Integer.TYPE, 51);
        typeCodes.put(Double.TYPE, 61);
        typeCodes.put(Boolean.TYPE, 20);
        typeCodes.put(Long.TYPE, 52);
        typeCodes.put(Short.TYPE, 50);
        typeCodes.put(Float.TYPE, 60);
        typeCodes.put(Byte.TYPE, 40);
        typeCodes.put(Character.TYPE, 30);
    }
}

