/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import leap.lang.el.ElFunction;
import leap.lang.el.ElParseContext;

public class ParentChildElParseContext
implements ElParseContext {
    private final ElParseContext parent;
    private final ElParseContext child;
    private final List<String> pkgs = new ArrayList<String>();
    private final List<String> pkgsImmutableView = Collections.unmodifiableList(this.pkgs);

    public ParentChildElParseContext(ElParseContext parent, ElParseContext child) {
        this.parent = parent;
        this.child = child;
        for (String p : parent.getImportedPackages()) {
            if (child.getImportedPackages().contains(p)) continue;
            this.pkgs.add(p);
        }
        this.pkgs.addAll(child.getImportedPackages());
    }

    @Override
    public List<String> getImportedPackages() {
        return this.pkgsImmutableView;
    }

    @Override
    public <T> T convert(Object v, Class<T> targetType) {
        return this.child.convert(v, targetType);
    }

    @Override
    public String toString(Object v) {
        return this.child.toString();
    }

    @Override
    public boolean test(Object v) {
        return this.child.test(v);
    }

    @Override
    public String getMessage(String key, Object ... args) {
        return this.child.getMessage(key, args);
    }

    @Override
    public Object resolveVariable(String name) {
        Object o = this.child.resolveVariable(name);
        return null == o ? this.parent.resolveVariable(name) : o;
    }

    @Override
    public ElFunction resolveFunction(String fullname) {
        ElFunction f = this.child.resolveFunction(fullname);
        return null == f ? this.parent.resolveFunction(fullname) : f;
    }
}

