/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import leap.lang.Objects2;
import leap.lang.el.DefaultElParseContext;
import leap.lang.el.ElException;
import leap.lang.el.ElFunction;
import leap.lang.el.ElParseContext;
import leap.lang.el.ElParseException;
import leap.lang.el.spel.SpelExpression;
import leap.lang.el.spel.parser.Parser;
import leap.lang.expression.CompositeExpression;
import leap.lang.expression.ExpressionException;

public class SPEL {
    private static final Map<String, ElFunction> functions = new ConcurrentHashMap<String, ElFunction>();
    private static final DefaultElParseContext parseContext = new DefaultElParseContext(functions);
    public static final String PREFIX = "${";
    public static final String SUFFIX = "}";

    public static ElParseContext getDefaultParseContext() {
        return parseContext;
    }

    public static String removePrefixAndSuffix(String s) {
        if (null != s && s.startsWith(PREFIX)) {
            if (!s.endsWith(SUFFIX)) {
                throw new IllegalArgumentException("Unclosed expression '" + s + "', must be ends with '}'");
            }
            return s.substring(2, s.length() - 1);
        }
        return s;
    }

    public static boolean hasPrefixAndSuffix(String s) {
        if (null == s) {
            return false;
        }
        return (s = s.trim()).startsWith(PREFIX) && s.endsWith(SUFFIX);
    }

    public static SpelExpression createExpression(String expression) throws ElParseException {
        return SPEL.createExpression(parseContext, expression);
    }

    public static SpelExpression createExpression(ElParseContext context, String expression) throws ElParseException {
        return new SpelExpression(Parser.parse(context, expression));
    }

    public static CompositeExpression createCompositeExpression(String s) {
        return SPEL.parseCompositeExpression(parseContext, s);
    }

    public static CompositeExpression createCompositeExpression(ElParseContext context, String s) {
        return SPEL.parseCompositeExpression(context, s);
    }

    public static Object eval(String expression) throws ElException {
        return SPEL.createExpression(parseContext, expression).getValue();
    }

    public static Object eval(String expression, Object context) throws ElException {
        return SPEL.createExpression(parseContext, expression).getValue(context);
    }

    public static Object eval(String expression, Object context, Map<String, Object> vars) throws ElException {
        return SPEL.createExpression(parseContext, expression).getValue(context, vars);
    }

    protected static boolean testValue(Object v) {
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        return !Objects2.isEmpty(v);
    }

    private static CompositeExpression parseCompositeExpression(ElParseContext context, String str) {
        if (null == str) {
            return CompositeExpression.NULL;
        }
        if ("".equals(str)) {
            return CompositeExpression.EMPTY;
        }
        if (str.indexOf(PREFIX) >= 0) {
            return new CompositeExpression(str, SPEL.parseNodes(context, str));
        }
        return new CompositeExpression(str);
    }

    private static Object[] parseNodes(ElParseContext context, String s) {
        StringBuilder buf = new StringBuilder(s);
        ArrayList<Object> nodes = new ArrayList<Object>();
        int startIndex = SPEL.nextEvalPrefix(buf, 0);
        int mark = 0;
        while (startIndex >= 0) {
            int endIndex = buf.indexOf(SUFFIX, startIndex + 2);
            if (endIndex > 0) {
                if (mark < startIndex) {
                    nodes.add(buf.substring(mark, startIndex));
                }
                nodes.add(SPEL.createExpression(context, buf.substring(startIndex + 2, endIndex)));
                if (endIndex == buf.length() - 1) {
                    mark = buf.length();
                    break;
                }
                mark = endIndex + 1;
                startIndex = SPEL.nextEvalPrefix(buf, endIndex + 1);
                continue;
            }
            throw new ExpressionException("Unclosed expression starts from " + startIndex + ", expected suffix '}'");
        }
        if (mark < buf.length()) {
            nodes.add(buf.substring(mark));
        }
        return nodes.toArray(new Object[nodes.size()]);
    }

    private static int nextEvalPrefix(StringBuilder str, int from) {
        int i = str.indexOf(PREFIX, from);
        if (i > 0 && str.charAt(i - 1) == '\\') {
            str.deleteCharAt(i - 1);
            return SPEL.nextEvalPrefix(str, i + 1);
        }
        return i;
    }

    protected SPEL() {
    }
}

