/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import leap.lang.Strings;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElFunction;
import leap.lang.el.ElMethod;
import leap.lang.el.ElParseContext;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstInvocable;
import leap.lang.el.spel.ast.AstVisitor;

public class AstFunction
extends AstInvocable {
    private String prefix;
    private String fullName;
    private ElFunction func;

    public AstFunction() {
    }

    public AstFunction(ElParseContext context, String name, AstExpr[] parameters) {
        this(context, null, name, parameters);
    }

    public AstFunction(ElParseContext context, String prefix, String name, AstExpr[] parameters) {
        super(name, parameters);
        this.prefix = prefix;
        this.fullName = Strings.isEmpty(prefix) ? name : prefix + ":" + name;
        this.func = context.resolveFunction(this.fullName);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Object eval(ElEvalContext context) {
        try {
            Object[] args = this.evalParameters(context);
            if (null == this.func) {
                ElMethod m;
                Object root;
                if (null == this.prefix && null != (root = context.getRoot()) && null != (m = context.resolveMethod(root, root.getClass(), this.name, args))) {
                    return m.invoke(context, root, this.evalParameters(context));
                }
                ElFunction func = context.resolveFunction(this.fullName);
                if (null == func) {
                    throw new ElException(context.getMessage("el.errors.noSuchFunction", this.fullName));
                }
                return func.invoke(context, args);
            }
            return this.func.invoke(context, args);
        }
        catch (ElException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ElException(context.getMessage("el.errors.functionInvokeError", this.fullName, e.getMessage()), e);
        }
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        if (visitor.startVisit(this)) {
            this.acceptChilds(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        if (!Strings.isEmpty(this.prefix)) {
            buf.append(this.prefix).append(':');
        }
        super.toString(buf);
    }
}

