/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import leap.lang.Arrays2;
import leap.lang.el.ElEvalContext;
import leap.lang.el.spel.ast.AstExpr;

public abstract class AstInvocable
extends AstExpr {
    protected String name;
    protected AstExpr[] parameters;

    public AstInvocable() {
    }

    public AstInvocable(String name, AstExpr[] parameters) {
        this.name = name;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AstExpr[] getParameters() {
        return this.parameters;
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append(this.name);
        buf.append("(");
        int size = this.parameters.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            this.parameters[i].toString(buf);
        }
        buf.append(")");
    }

    protected Object[] evalParameters(ElEvalContext context) {
        if (this.parameters.length == 0) {
            return Arrays2.EMPTY_OBJECT_ARRAY;
        }
        Object[] args = new Object[this.parameters.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.parameters[i].eval(context);
        }
        return args;
    }
}

