/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.util.Map;
import leap.lang.Beans;
import leap.lang.beans.BeanType;
import leap.lang.beans.DynaBean;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElPropertyResolver;
import leap.lang.el.ElTypes;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstVisitor;

public class AstItem
extends AstExpr {
    private AstExpr array;
    private AstExpr index;

    public AstItem() {
    }

    public AstItem(AstExpr array, AstExpr index) {
        this.array = array;
        this.index = index;
    }

    public AstExpr getArray() {
        return this.array;
    }

    public void setArray(AstExpr array) {
        this.array = array;
    }

    public AstExpr getIndex() {
        return this.index;
    }

    public void setIndex(AstExpr index) {
        this.index = index;
    }

    @Override
    public Object eval(ElEvalContext context) {
        Object a;
        Object i = this.index.eval(context);
        if (null == i) {
            throw new ElException(context.getMessage("el.errors.nullArrayIndex", this.toString()));
        }
        int type = ElTypes.resolveTypeByVal(i);
        if (type == 10) {
            Object a2;
            Object object = a2 = null == this.array ? context.getRoot() : this.array.eval(context);
            if (null == a2) {
                return null;
            }
            return this.getProperty(context, a2, (String)i);
        }
        Object object = a = null == this.array ? context.getRoot() : this.array.eval(context);
        if (null == a) {
            throw new ElException(context.getMessage("el.errors.nullArrayValue", this.toString()));
        }
        return this.getArray(context, a, type, i);
    }

    protected Object getProperty(ElEvalContext context, Object o, String name) {
        if (o instanceof Map) {
            return ((Map)o).get(name);
        }
        if (o instanceof ElPropertyResolver) {
            return ((ElPropertyResolver)o).resovleProperty(name);
        }
        if (o instanceof DynaBean) {
            return ((DynaBean)o).getProperty(name);
        }
        return Beans.getProperty(BeanType.of(o.getClass()), o, name);
    }

    protected Object getArray(ElEvalContext context, Object a, int itype, Object ival) {
        if (itype <= 49) {
            throw new ElException(context.getMessage("el.errors.invalidArrayIndex", this.toString(), "'" + ival + "' is not a vaid integer value"));
        }
        int index = ((Number)ival).intValue();
        return context.getArrayItem(a, index);
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        if (visitor.startVisit(this)) {
            this.acceptChild(visitor, this.array);
            this.acceptChild(visitor, this.index);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        this.array.toString(buf);
        buf.append("[");
        this.index.toString(buf);
        buf.append("]");
    }
}

