/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.io.Serializable;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElMethod;
import leap.lang.el.ElMethodInvocable;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstInvocable;
import leap.lang.el.spel.ast.AstProperty;
import leap.lang.el.spel.ast.AstVisitor;

public class AstMethod
extends AstInvocable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private AstExpr owner;
    private Class<?> c;
    private ElMethod m;

    public AstMethod() {
    }

    public AstMethod(AstExpr owner, String name, AstExpr[] parameters) {
        super(name, parameters);
        this.owner = owner;
    }

    public AstExpr getOwner() {
        return this.owner;
    }

    public void setOwner(AstExpr owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ElEvalContext context) {
        Object o = this.owner.eval(context);
        if (null == o) {
            return null;
        }
        if (o instanceof ElMethodInvocable) {
            try {
                return ((ElMethodInvocable)o).invokeMethod(context, this.name, this.evalParameters(context));
            }
            catch (Throwable e) {
                throw new ElException(context.getMessage("el.errors.methodInvokeError", this.name, o, e.getMessage()), e);
            }
        }
        Object[] args = this.evalParameters(context);
        if (null == this.m) {
            AstMethod astMethod = this;
            synchronized (astMethod) {
                if (null == this.m) {
                    if (o instanceof Class) {
                        this.c = (Class)o;
                        this.m = this.resolveMethod(context, this.c, args);
                    } else {
                        this.c = o.getClass();
                        this.m = this.resolveMethod(context, o, this.c, args);
                    }
                }
            }
        }
        ElMethod m = this.m;
        Class<?> c = AstProperty.cls(o);
        if (this.c != c) {
            m = c == o ? this.resolveMethod(context, c, args) : this.resolveMethod(context, o, c, args);
        }
        try {
            return m.invoke(context, o, args);
        }
        catch (Throwable e) {
            throw new ElException(context.getMessage("el.errors.methodInvokeError", this.name, o, e.getMessage()), e);
        }
    }

    protected ElMethod resolveMethod(ElEvalContext ctx, Class<?> c, Object[] args) {
        ElMethod m = ctx.resolveMethod(c, this.name, args);
        if (null == m) {
            throw new ElException(ctx.getMessage("el.errors.noSuchMethod", this.name, c));
        }
        return m;
    }

    protected ElMethod resolveMethod(ElEvalContext ctx, Object owner, Class<?> c, Object[] args) {
        ElMethod m = ctx.resolveMethod(owner, c, this.name, args);
        if (null == m) {
            throw new ElException(ctx.getMessage("el.errors.noSuchMethod", this.name, c));
        }
        return m;
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        if (visitor.startVisit(this)) {
            this.acceptChild(visitor, this.owner);
            this.acceptChilds(visitor, this.parameters);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        this.owner.toString(buf);
        buf.append(".");
        super.toString(buf);
    }
}

