/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.util.Map;
import leap.lang.Named;
import leap.lang.accessor.Getter;
import leap.lang.accessor.ObjectPropertyGetter;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElParseContext;
import leap.lang.el.ElProperty;
import leap.lang.el.ElPropertyResolver;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstVisitor;

public class AstProperty
extends AstExpr
implements Named {
    private AstExpr owner;
    private String name;
    private String qName;
    private Class<?> c;
    private ElProperty p;

    public AstProperty() {
    }

    public AstProperty(AstExpr owner, String name) {
        this.owner = owner;
        this.name = name;
    }

    public AstProperty(ElParseContext context, AstExpr owner, String name) {
        this(owner, name);
    }

    public AstExpr getOwner() {
        return this.owner;
    }

    public void setOwner(AstExpr owner) {
        this.owner = owner;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(ElEvalContext context) {
        Object o;
        if (null == this.qName) {
            this.qName = this.owner.toString() + "." + this.name;
            o = context.resolveVariable(this.qName);
            if (null != o) {
                return o;
            }
        } else {
            o = context.resolveVariable(this.qName);
            if (null != o) {
                return o;
            }
        }
        if (null == (o = this.owner.eval(context))) {
            return null;
        }
        if (o instanceof Map) {
            return ((Map)o).get(this.name);
        }
        if (o instanceof ElPropertyResolver) {
            return ((ElPropertyResolver)o).resovleProperty(this.name);
        }
        if (o instanceof ObjectPropertyGetter) {
            return ((ObjectPropertyGetter)o).getProperty(this.name);
        }
        if (o instanceof Getter) {
            return ((Getter)o).get(this.name);
        }
        if (null == this.p) {
            AstProperty astProperty = this;
            synchronized (astProperty) {
                if (null == this.p) {
                    if (o instanceof Class) {
                        this.c = (Class)o;
                        this.p = this.resolveProperty(context, this.c);
                    } else {
                        this.c = o.getClass();
                        this.p = this.resolveProperty(context, o, this.c);
                    }
                }
            }
        }
        ElProperty p = this.p;
        Class<?> c = AstProperty.cls(o);
        if (this.c != c) {
            p = c == o ? this.resolveProperty(context, c) : this.resolveProperty(context, o, c);
        }
        try {
            return p.getValue(context, o);
        }
        catch (Throwable e) {
            throw new ElException(context.getMessage("el.errors.getPropertyError", this.name, o, e.getMessage()), e);
        }
    }

    protected ElProperty resolveProperty(ElEvalContext ctx, Class<?> c) {
        ElProperty p = ctx.resolveProperty(c, this.name);
        if (null == p) {
            throw new ElException(ctx.getMessage("el.errors.noSuchProperty", this.name, c));
        }
        return p;
    }

    protected ElProperty resolveProperty(ElEvalContext ctx, Object o, Class<?> c) {
        ElProperty p = ctx.resolveProperty(o, c, this.name);
        if (null == p) {
            throw new ElException(ctx.getMessage("el.errors.noSuchProperty", this.name, c));
        }
        return p;
    }

    static Class<?> cls(Object o) {
        Class<?> c = o.getClass();
        if (c == Class.class) {
            return (Class)o;
        }
        return c;
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        if (visitor.startVisit(this)) {
            this.acceptChild(visitor, this.owner);
        }
        visitor.endVisit(this);
    }

    @Override
    public void toString(StringBuilder buf) {
        this.owner.toString(buf);
        buf.append(".");
        buf.append(this.name);
    }
}

