/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.util.List;
import java.util.Set;
import leap.lang.Classes;
import leap.lang.New;
import leap.lang.Strings;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElParseContext;
import leap.lang.el.ElParseException;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstVisitor;

public class AstType
extends AstExpr {
    private static final List<String> DEFAULT_PACKAGES = New.arrayList("java.lang", "java.util", Classes.getPackageName(Strings.class));
    private static final Set<String> UNSAFED_CLASSES = New.hashSet("java.lang.System");
    private String name;
    private Class<?> cls;

    public AstType(ElParseContext context, String name) {
        this.name = name;
        this.cls = this.resolveClass(context, name);
        if (null == this.cls) {
            throw new ElParseException("Class name '" + name + "' cannot be resolved");
        }
        if (UNSAFED_CLASSES.contains(this.cls.getName())) {
            throw new ElParseException("Class '" + this.cls.getName() + "' is unsafe, cannot use it in el");
        }
    }

    @Override
    public Object eval(ElEvalContext context) {
        return this.cls;
    }

    @Override
    public void toString(StringBuilder out) {
        out.append("T(").append(this.name).append(")");
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        visitor.startVisit(this);
    }

    protected Class<?> resolveClass(ElParseContext context, String name) {
        Class<?> cls = null;
        cls = Classes.tryForName(name);
        if (cls != null) {
            return cls;
        }
        cls = this.resolveClass(context.getImportedPackages(), name);
        if (cls != null) {
            return cls;
        }
        cls = this.resolveClass(DEFAULT_PACKAGES, name);
        if (cls != null) {
            return cls;
        }
        return null;
    }

    protected Class<?> resolveClass(List<String> pkgs, String name) {
        for (int i = pkgs.size() - 1; i >= 0; --i) {
            String pkg = pkgs.get(i);
            this.cls = Classes.tryForName(pkg + "." + name);
            if (this.cls == null) continue;
            return this.cls;
        }
        return null;
    }
}

