/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import leap.lang.el.ElEvalContext;
import leap.lang.el.ElTypes;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstNode;
import leap.lang.el.spel.ast.AstVisitor;
import leap.lang.el.spel.ast.Ops;

public class AstUnary
extends AstExpr {
    public static final UOperator NOT = new AbstractOperator("!"){

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            return !context.test(expr.eval(context));
        }
    };
    public static final UOperator PLUS = new AbstractOperator("+"){

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            return expr.eval(context);
        }
    };
    public static final UOperator MINUS = new AbstractOperator("-"){

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            return Ops.minus(context, type, expr.eval(context));
        }
    };
    public static final UOperator PRE_PLUSPLUS = new AbstractOperator("++"){

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            throw new IllegalStateException("++ operator not supported now");
        }
    };
    public static final UOperator POST_PLUSPLUS = new AbstractOperator("++"){

        @Override
        public boolean isPrepositive() {
            return false;
        }

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            throw new IllegalStateException("++ operator not supported now");
        }
    };
    public static final UOperator PRE_SUBSUB = new AbstractOperator("--"){

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            throw new IllegalStateException("-- operator not supported now");
        }
    };
    public static final UOperator POST_SUBSUB = new AbstractOperator("--"){

        @Override
        public boolean isPrepositive() {
            return false;
        }

        @Override
        public Object eval(ElEvalContext context, int type, AstNode expr) {
            throw new IllegalStateException("-- operator not supported now");
        }
    };
    private AstExpr expr;
    private int type;
    private UOperator operator;

    public AstUnary() {
    }

    public AstUnary(AstExpr expr, UOperator operator) {
        this.expr = expr;
        this.type = ElTypes.resolveType(expr.resultType);
        this.operator = operator;
    }

    public AstExpr getExpr() {
        return this.expr;
    }

    public void setExpr(AstExpr expr) {
        this.expr = expr;
    }

    public UOperator getOperator() {
        return this.operator;
    }

    public void setOperator(UOperator operator) {
        this.operator = operator;
    }

    @Override
    public Object eval(ElEvalContext context) {
        return this.operator.eval(context, this.type, this.expr);
    }

    @Override
    protected void doAccept(AstVisitor visitor) {
        if (visitor.startVisit(this)) {
            this.acceptChild(visitor, this.expr);
        }
        visitor.endVisit(this);
    }

    public static abstract class AbstractOperator
    implements UOperator {
        protected final String literal;

        public AbstractOperator(String literal) {
            this.literal = literal;
        }

        @Override
        public boolean isPrepositive() {
            return true;
        }

        @Override
        public String getLiteral() {
            return this.literal;
        }

        public String toString() {
            return this.literal;
        }

        @Override
        public Class<?> getResultType(int type, Class<?> cls) {
            return null;
        }
    }

    public static interface UOperator {
        public boolean isPrepositive();

        public String getLiteral();

        public Class<?> getResultType(int var1, Class<?> var2);

        public Object eval(ElEvalContext var1, int var2, AstNode var3);
    }
}

