/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import leap.lang.el.ElEvalContext;

abstract class Coerce {
    public static final Long LG_ONE = new Long(1L);
    public static final Long LG_ZERO = new Long(0L);
    public static final Double DB_ONE = new Double(1.0);
    public static final Double DB_ZERO = new Double(0.0);
    public static final BigInteger BI_ONE = new BigInteger("1");
    public static final BigInteger BI_ZERO = new BigInteger("0");
    public static final BigDecimal BD_ZERO = new BigDecimal("0");

    Coerce() {
    }

    public static BigDecimal toBigDecimal(ElEvalContext ctx, int type, Object val) {
        if (type == 70) {
            return (BigDecimal)val;
        }
        if (val == null || "".equals(val)) {
            return BD_ZERO;
        }
        switch (type) {
            case 70: {
                return new BigDecimal(((BigDecimal)val).doubleValue());
            }
            case 71: {
                return new BigDecimal((BigInteger)val);
            }
            case 51: 
            case 54: {
                return new BigDecimal((Integer)val);
            }
            case 52: 
            case 55: {
                return new BigDecimal((Long)val);
            }
            case 10: {
                return new BigDecimal((String)val);
            }
            case 60: 
            case 62: {
                return new BigDecimal(((Float)val).floatValue());
            }
            case 61: 
            case 63: {
                return new BigDecimal((Double)val);
            }
            case 50: 
            case 53: {
                return new BigDecimal(((Short)val).shortValue());
            }
            case 30: 
            case 31: {
                return new BigDecimal(((Character)val).charValue());
            }
            case 20: 
            case 21: {
                return new BigDecimal((Boolean)val != false ? 1 : 0);
            }
            case 40: 
            case 41: {
                return new BigDecimal(((Byte)val).intValue());
            }
        }
        return ctx.convert(val, BigDecimal.class);
    }

    public static BigInteger toBigInteger(ElEvalContext ctx, int type, Object val) {
        if (type == 71) {
            return (BigInteger)val;
        }
        if (val == null || "".equals(val)) {
            return BI_ZERO;
        }
        if (type > 49) {
            return BigInteger.valueOf(((Number)val).longValue());
        }
        switch (type) {
            case 30: 
            case 31: {
                return BigInteger.valueOf(((Character)val).charValue());
            }
            case 20: 
            case 21: {
                return (Boolean)val != false ? BI_ONE : BI_ZERO;
            }
            case 40: 
            case 41: {
                return BigInteger.valueOf(((Byte)val).byteValue());
            }
        }
        return ctx.convert(val, BigInteger.class);
    }

    public static Double toDouble(ElEvalContext ctx, int type, Object val) {
        if (type == 63 || type == 61) {
            return (Double)val;
        }
        if (val == null || "".equals(val)) {
            return DB_ZERO;
        }
        switch (type) {
            case 70: {
                return ((Number)val).doubleValue();
            }
            case 71: {
                return ((Number)val).doubleValue();
            }
            case 51: 
            case 54: {
                return ((Number)val).doubleValue();
            }
            case 52: 
            case 55: {
                return ((Number)val).doubleValue();
            }
            case 10: {
                return Double.parseDouble((String)val);
            }
            case 60: 
            case 62: {
                return ((Number)val).doubleValue();
            }
            case 61: 
            case 63: {
                return (Double)val;
            }
            case 50: 
            case 53: {
                return ((Number)val).doubleValue();
            }
            case 30: 
            case 31: {
                return Double.parseDouble(String.valueOf((Character)val));
            }
            case 20: 
            case 21: {
                return (Boolean)val != false ? DB_ONE : DB_ZERO;
            }
            case 40: 
            case 41: {
                return ((Byte)val).doubleValue();
            }
        }
        return ctx.convert(val, Double.class);
    }

    public static Long toLong(ElEvalContext ctx, int type, Object val) {
        if (type == 55 || type == 52) {
            return (Long)val;
        }
        if (val == null || "".equals(val)) {
            return LG_ZERO;
        }
        if (type > 49) {
            return ((Number)val).longValue();
        }
        switch (type) {
            case 30: 
            case 31: {
                return ((Character)val).charValue();
            }
            case 20: 
            case 21: {
                return (Boolean)val != false ? LG_ONE : LG_ZERO;
            }
            case 40: 
            case 41: {
                return (long)((Byte)val);
            }
        }
        return ctx.convert(val, Long.class);
    }

    public static Boolean toBoolean(ElEvalContext ctx, int type, Object val) {
        if (type == 21 || type == 20) {
            return (Boolean)val;
        }
        if (type > 49) {
            return ((Number)val).doubleValue() != 0.0;
        }
        return ctx.convert(val, Boolean.class);
    }

    public static String toString(ElEvalContext ctx, int type, Object val) {
        if (type == 10) {
            return (String)val;
        }
        return ctx.toString(val);
    }
}

