/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.math.BigDecimal;
import java.math.BigInteger;
import leap.lang.el.ElEvalContext;
import leap.lang.el.ElException;
import leap.lang.el.ElTypes;
import leap.lang.el.spel.ast.Coerce;

class Ops {
    static Object add(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (null == lval && null == rval) {
            return Coerce.LG_ZERO;
        }
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype > 29 || rtype > 29) {
            if (ltype == 70 || rtype == 70) {
                return Coerce.toBigDecimal(ctx, ltype, lval).add(Coerce.toBigDecimal(ctx, rtype, rval));
            }
            if (Ops.isFloatOrDoubleOrDotEe(ltype, lval) || Ops.isFloatOrDoubleOrDotEe(rtype, rval)) {
                if (ltype == 71 || rtype == 71) {
                    return Coerce.toBigDecimal(ctx, ltype, lval).add(Coerce.toBigDecimal(ctx, rtype, rval));
                }
                return Coerce.toDouble(ctx, ltype, lval) + Coerce.toDouble(ctx, rtype, rval);
            }
            if (ltype == 71 || rtype == 71) {
                return Coerce.toBigInteger(ctx, ltype, lval).add(Coerce.toBigInteger(ctx, rtype, rval));
            }
            return Coerce.toLong(ctx, ltype, lval) + Coerce.toLong(ctx, rtype, rval);
        }
        return ctx.toString(lval) + ctx.toString(rval);
    }

    static Object sub(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (null == lval && null == rval) {
            return Coerce.LG_ZERO;
        }
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).subtract(Coerce.toBigDecimal(ctx, rtype, rval));
        }
        if (Ops.isFloatOrDoubleOrDotEe(ltype, lval) || Ops.isFloatOrDoubleOrDotEe(rtype, rval)) {
            if (ltype == 71 || rtype == 71) {
                return Coerce.toBigDecimal(ctx, ltype, lval).subtract(Coerce.toBigDecimal(ctx, rtype, rval));
            }
            return Coerce.toDouble(ctx, ltype, lval) - Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).subtract(Coerce.toBigInteger(ctx, rtype, rval));
        }
        return Coerce.toLong(ctx, ltype, lval) - Coerce.toLong(ctx, rtype, rval);
    }

    static Object mul(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (null == lval && null == rval) {
            return Coerce.LG_ZERO;
        }
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).multiply(Coerce.toBigDecimal(ctx, rtype, rval));
        }
        if (Ops.isFloatOrDoubleOrDotEe(ltype, lval) || Ops.isFloatOrDoubleOrDotEe(rtype, rval)) {
            if (ltype == 71 || rtype == 71) {
                return Coerce.toBigDecimal(ctx, ltype, lval).multiply(Coerce.toBigDecimal(ctx, rtype, rval));
            }
            return Coerce.toDouble(ctx, ltype, lval) * Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).multiply(Coerce.toBigInteger(ctx, rtype, rval));
        }
        return Coerce.toLong(ctx, ltype, lval) * Coerce.toLong(ctx, rtype, rval);
    }

    static Object div(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (null == lval && null == rval) {
            return Coerce.LG_ZERO;
        }
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype > 69 || rtype > 69) {
            return Coerce.toBigDecimal(ctx, ltype, lval).divide(Coerce.toBigDecimal(ctx, rtype, rval), 4);
        }
        return Coerce.toDouble(ctx, ltype, lval) / Coerce.toDouble(ctx, rtype, rval);
    }

    static Object mod(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (null == lval && null == rval) {
            return Coerce.LG_ZERO;
        }
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || Ops.isFloatOrDoubleOrDotEe(ltype, lval) || rtype == 70 || Ops.isFloatOrDoubleOrDotEe(rtype, rval)) {
            return Coerce.toDouble(ctx, ltype, lval) % Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).remainder(Coerce.toBigInteger(ctx, rtype, rval));
        }
        return Coerce.toLong(ctx, ltype, lval) % Coerce.toLong(ctx, rtype, rval);
    }

    static Object eq(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ElTypes.isBoolean(ltype) || ElTypes.isBoolean(rtype)) {
            return Coerce.toBoolean(ctx, ltype, lval) == Coerce.toBoolean(ctx, rtype, rval);
        }
        if (ltype == 2) {
            if (rtype == 2) {
                return lval.equals(rval);
            }
            return lval.equals(ctx.convert(rval, lval.getClass()));
        }
        if (rtype == 2) {
            if (ltype == 2) {
                return rval.equals(lval);
            }
            return rval.equals(ctx.convert(lval, rval.getClass()));
        }
        if (ltype == 10 || rtype == 10) {
            return Coerce.toString(ctx, ltype, lval).equals(Coerce.toString(ctx, rtype, rval));
        }
        if (ltype > 29 || rtype > 29) {
            if (ltype == 70 || rtype == 70) {
                return Coerce.toBigDecimal(ctx, ltype, lval).equals(Coerce.toBigDecimal(ctx, rtype, rval));
            }
            if (ElTypes.isFloatOrDouble(ltype) || ElTypes.isFloatOrDouble(rtype)) {
                return Coerce.toDouble(ctx, ltype, lval) == Coerce.toDouble(ctx, rtype, rval);
            }
            if (ltype == 71 || rtype == 71) {
                return Coerce.toBigInteger(ctx, ltype, lval).equals(Coerce.toBigInteger(ctx, rtype, rval));
            }
            return Coerce.toLong(ctx, ltype, lval) == Coerce.toLong(ctx, rtype, rval);
        }
        return lval.equals(rval);
    }

    static Object ge(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).compareTo(Coerce.toBigDecimal(ctx, rtype, rval)) >= 0;
        }
        if (ElTypes.isFloatOrDouble(ltype) || ElTypes.isFloatOrDouble(rtype)) {
            return Coerce.toDouble(ctx, ltype, lval) >= Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).compareTo(Coerce.toBigInteger(ctx, rtype, rval)) >= 0;
        }
        if (ltype > 29 || rtype > 29) {
            return Coerce.toLong(ctx, ltype, lval) >= Coerce.toLong(ctx, rtype, rval);
        }
        if (ltype == 10 || rtype == 10) {
            return Coerce.toString(ctx, ltype, lval).compareTo(Coerce.toString(ctx, rtype, rval)) >= 0;
        }
        if (lval instanceof Comparable) {
            return ((Comparable)lval).compareTo(rval) >= 0;
        }
        if (rval instanceof Comparable) {
            return ((Comparable)rval).compareTo(lval) < 0;
        }
        throw new ElException(ctx.getMessage("el.errors.valuesNotComparable", lval, rval));
    }

    static Object gt(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).compareTo(Coerce.toBigDecimal(ctx, rtype, rval)) > 0;
        }
        if (ElTypes.isFloatOrDouble(ltype) || ElTypes.isFloatOrDouble(rtype)) {
            return Coerce.toDouble(ctx, ltype, lval) > Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).compareTo(Coerce.toBigInteger(ctx, rtype, rval)) > 0;
        }
        if (ltype > 29 || rtype > 29) {
            return Coerce.toLong(ctx, ltype, lval) > Coerce.toLong(ctx, rtype, rval);
        }
        if (ltype == 10 || rtype == 10) {
            return Coerce.toString(ctx, ltype, lval).compareTo(Coerce.toString(ctx, rtype, rval)) > 0;
        }
        if (lval instanceof Comparable) {
            return ((Comparable)lval).compareTo(rval) > 0;
        }
        if (rval instanceof Comparable) {
            return ((Comparable)rval).compareTo(lval) <= 0;
        }
        throw new ElException(ctx.getMessage("el.errors.valuesNotComparable", lval, rval));
    }

    static Object lt(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).compareTo(Coerce.toBigDecimal(ctx, rtype, rval)) < 0;
        }
        if (ElTypes.isFloatOrDouble(ltype) || ElTypes.isFloatOrDouble(rtype)) {
            return Coerce.toDouble(ctx, ltype, lval) < Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).compareTo(Coerce.toBigInteger(ctx, rtype, rval)) < 0;
        }
        if (ltype > 29 || rtype > 29) {
            return Coerce.toLong(ctx, ltype, lval) < Coerce.toLong(ctx, rtype, rval);
        }
        if (ltype == 10 || rtype == 10) {
            return Coerce.toString(ctx, ltype, lval).compareTo(Coerce.toString(ctx, rtype, rval)) < 0;
        }
        if (lval instanceof Comparable) {
            return ((Comparable)lval).compareTo(rval) < 0;
        }
        if (rval instanceof Comparable) {
            return ((Comparable)rval).compareTo(lval) >= 0;
        }
        throw new ElException(ctx.getMessage("el.errors.valuesNotComparable", lval, rval));
    }

    static Object le(ElEvalContext ctx, int ltype, Object lval, int rtype, Object rval) {
        if (ltype == -1) {
            ltype = ElTypes.resolveTypeByVal(lval);
        }
        if (rtype == -1) {
            rtype = ElTypes.resolveTypeByVal(rval);
        }
        if (ltype == 70 || rtype == 70) {
            return Coerce.toBigDecimal(ctx, ltype, lval).compareTo(Coerce.toBigDecimal(ctx, rtype, rval)) <= 0;
        }
        if (ElTypes.isFloatOrDouble(ltype) || ElTypes.isFloatOrDouble(rtype)) {
            return Coerce.toDouble(ctx, ltype, lval) <= Coerce.toDouble(ctx, rtype, rval);
        }
        if (ltype == 71 || rtype == 71) {
            return Coerce.toBigInteger(ctx, ltype, lval).compareTo(Coerce.toBigInteger(ctx, rtype, rval)) <= 0;
        }
        if (ltype > 29 || rtype > 29) {
            return Coerce.toLong(ctx, ltype, lval) <= Coerce.toLong(ctx, rtype, rval);
        }
        if (ltype == 10 || rtype == 10) {
            return Coerce.toString(ctx, ltype, lval).compareTo(Coerce.toString(ctx, rtype, rval)) < 0;
        }
        if (lval instanceof Comparable) {
            return ((Comparable)lval).compareTo(rval) <= 0;
        }
        if (rval instanceof Comparable) {
            return ((Comparable)rval).compareTo(lval) > 0;
        }
        throw new ElException(ctx.getMessage("el.errors.valuesNotComparable", lval, rval));
    }

    static Object minus(ElEvalContext ctx, int type, Object val) {
        if (val == null) {
            return Coerce.LG_ZERO;
        }
        if (type == -1) {
            type = ElTypes.resolveTypeByVal(val);
        }
        if (type == 70) {
            return ((BigDecimal)val).negate();
        }
        if (type == 71) {
            return ((BigInteger)val).negate();
        }
        if (type == 10) {
            if (Ops.isDotEe((String)val)) {
                return -Coerce.toDouble(ctx, type, val).doubleValue();
            }
            return -Coerce.toLong(ctx, type, val).longValue();
        }
        if (type > 39) {
            if (type == 54 || type == 51) {
                return -((Integer)val).intValue();
            }
            if (type == 55 || type == 52) {
                return -((Long)val).longValue();
            }
            if (type == 63 || type == 61) {
                return -((Double)val).doubleValue();
            }
            if (type == 62 || type == 60) {
                return Float.valueOf(-((Float)val).floatValue());
            }
            if (type == 53 || type == 50) {
                return (int)(-((Short)val).shortValue());
            }
            if (type == 41 || type == 40) {
                return (int)(-((Byte)val).byteValue());
            }
        }
        throw new ElException(ctx.getMessage("el.errors.cannotApplyMinusOperatorTo", val));
    }

    private static final boolean isFloatOrDoubleOrDotEe(int type, Object val) {
        return ElTypes.isFloatOrDouble(type) || type == 10 && Ops.isDotEe((String)val);
    }

    private static final boolean isDotEe(String value) {
        if (!(value instanceof String)) {
            return false;
        }
        String s = value;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            switch (s.charAt(i)) {
                case '.': 
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return false;
    }

    protected Ops() {
    }
}

