/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.ast;

import java.io.PrintWriter;
import leap.lang.el.spel.ast.AstBinary;
import leap.lang.el.spel.ast.AstBoolean;
import leap.lang.el.spel.ast.AstChoice;
import leap.lang.el.spel.ast.AstIdentifier;
import leap.lang.el.spel.ast.AstItem;
import leap.lang.el.spel.ast.AstMethod;
import leap.lang.el.spel.ast.AstNode;
import leap.lang.el.spel.ast.AstNull;
import leap.lang.el.spel.ast.AstNumber;
import leap.lang.el.spel.ast.AstProperty;
import leap.lang.el.spel.ast.AstString;
import leap.lang.el.spel.ast.AstUnary;
import leap.lang.el.spel.ast.AstVisitorAdapter;

public class PrintVisitor
extends AstVisitorAdapter {
    protected PrintWriter out;
    private String indent = "\t";
    private int indentCount = 0;

    public PrintVisitor(PrintWriter out) {
        this.out = out;
    }

    public void decrementIndent() {
        --this.indentCount;
    }

    public void incrementIndent() {
        ++this.indentCount;
    }

    public void printIndent() {
        for (int i = 0; i < this.indentCount; ++i) {
            this.print(this.indent);
        }
    }

    public void println() {
        this.print("\n");
        this.printIndent();
    }

    public void println(String text) {
        this.print(text);
        this.println();
    }

    public void print(String text) {
        this.out.print(text);
    }

    public void print(char ch) {
        this.out.print(ch);
    }

    @Override
    public boolean startVisit(AstBinary x) {
        AstBinary.BOperator op = x.getOperator();
        if (op == AstBinary.ADD) {
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.MUL) {
            this.print(" _multi(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.DIV) {
            this.print(" _div(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.SUB) {
            this.print(" _sub(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.GT) {
            this.print(" _gt(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.GE) {
            this.print(" _gteq(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.LT) {
            this.print(" _lt(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.LE) {
            this.print(" _lteq(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (op == AstBinary.EQ) {
            this.print(" _eq(");
            x.getLeft().accept(this);
            this.print(", ");
            x.getRight().accept(this);
            this.print(")");
            return false;
        }
        if (x.getLeft() instanceof AstBinary) {
            AstBinary left = (AstBinary)x.getLeft();
            if (left.getOperator().getPriority() > x.getOperator().getPriority()) {
                this.print('(');
                left.accept(this);
                this.print(')');
            } else {
                left.accept(this);
            }
        } else {
            x.getLeft().accept(this);
        }
        this.print(" ");
        this.print(x.getOperator().getLiteral());
        this.print(" ");
        if (x.getRight() instanceof AstBinary) {
            AstBinary right = (AstBinary)x.getRight();
            if (right.getOperator().getPriority() >= x.getOperator().getPriority()) {
                this.print('(');
                right.accept(this);
                this.print(')');
            } else {
                right.accept(this);
            }
        } else {
            x.getRight().accept(this);
        }
        return false;
    }

    @Override
    public boolean startVisit(AstIdentifier x) {
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean startVisit(AstNull x) {
        this.print("null");
        return false;
    }

    @Override
    public boolean startVisit(AstProperty x) {
        if (x.getOwner() instanceof AstBinary) {
            this.print('(');
            x.getOwner().accept(this);
            this.print(')');
        } else {
            x.getOwner().accept(this);
        }
        this.print(".");
        this.print(x.getName());
        return false;
    }

    @Override
    public boolean startVisit(AstMethod x) {
        if (x.getOwner() != null) {
            if (x.getOwner() instanceof AstBinary) {
                this.print('(');
                x.getOwner().accept(this);
                this.print(')');
            } else {
                x.getOwner().accept(this);
            }
            this.print(".");
        }
        this.print(x.getName());
        this.print("(");
        this.printAndAccept(x.getParameters(), ", ");
        this.print(")");
        return false;
    }

    @Override
    public boolean startVisit(AstNumber x) {
        Number value = x.getValue();
        if (value == null) {
            this.print("null");
            return false;
        }
        this.print(x.getValue().toString());
        return false;
    }

    @Override
    public boolean startVisit(AstChoice x) {
        x.getQuestion().accept(this);
        this.print(" ? ");
        x.getYes().accept(this);
        this.print(" : ");
        x.getNo().accept(this);
        return false;
    }

    @Override
    public boolean startVisit(AstBoolean x) {
        if (x.getValue().booleanValue()) {
            this.print("true");
        } else {
            this.print("false");
        }
        return false;
    }

    @Override
    public boolean startVisit(AstItem x) {
        x.getArray().accept(this);
        this.print("[");
        x.getIndex().accept(this);
        this.print("]");
        return false;
    }

    @Override
    public boolean startVisit(AstString x) {
        String value = x.getValue();
        if (value == null) {
            this.print("null");
        } else {
            this.print('\"');
            block8: for (char ch : value.toCharArray()) {
                switch (ch) {
                    case '\t': {
                        this.print("\\t");
                        continue block8;
                    }
                    case '\n': {
                        this.print("\\n");
                        continue block8;
                    }
                    case '\r': {
                        this.print("\\r");
                        continue block8;
                    }
                    case '\f': {
                        this.print("\\f");
                        continue block8;
                    }
                    case '\b': {
                        this.print("\\b");
                        continue block8;
                    }
                    case '\"': {
                        this.print("\\\"");
                        continue block8;
                    }
                    default: {
                        this.print(ch);
                    }
                }
            }
            this.print('\"');
        }
        return false;
    }

    @Override
    public boolean startVisit(AstUnary x) {
        AstUnary.UOperator o = x.getOperator();
        if (o == AstUnary.NOT) {
            if (x.getExpr() instanceof AstBinary) {
                this.print("(");
                x.getExpr().accept(this);
                this.print(")");
            } else {
                x.getExpr().accept(this);
            }
            return false;
        }
        if (o.isPrepositive()) {
            this.print(o.getLiteral());
            x.getExpr().accept(this);
        } else {
            x.getExpr().accept(this);
            this.print(o.getLiteral());
        }
        return false;
    }

    protected void printAndAccept(AstNode[] nodes, String seperator) {
        int size = nodes.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.print(seperator);
            }
            nodes[i].accept(this);
        }
    }
}

