/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import leap.lang.el.ElParseException;
import leap.lang.el.spel.parser.CharTypes;
import leap.lang.el.spel.parser.Keywords;
import leap.lang.el.spel.parser.SymbolTable;
import leap.lang.el.spel.parser.Token;

class Lexer {
    public static final byte EOI = 26;
    protected final char[] buf;
    protected int bp;
    protected int buflen;
    protected int eofPos;
    protected char ch;
    protected int pos;
    protected char[] sbuf;
    protected int sp;
    protected int np;
    protected SymbolTable symbolTable = new SymbolTable();
    private Token token;
    protected Keywords keywods = Keywords.DEFAULT;
    protected static final ThreadLocal<char[]> sbufRef = new ThreadLocal();
    protected String stringVal;
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final int[] digits = new int[58];

    public Lexer(String input) {
        this(input.toCharArray(), input.length());
    }

    public Lexer(char[] input, int inputLength) {
        this.sbuf = sbufRef.get();
        if (this.sbuf == null) {
            this.sbuf = new char[1024];
            sbufRef.set(this.sbuf);
        }
        this.eofPos = inputLength;
        if (inputLength == input.length) {
            if (input.length > 0 && Lexer.isWhitespace(input[input.length - 1])) {
                --inputLength;
            } else {
                char[] newInput = new char[inputLength + 1];
                System.arraycopy(input, 0, newInput, 0, input.length);
                input = newInput;
            }
        }
        this.buf = input;
        this.buflen = inputLength;
        this.buf[this.buflen] = 26;
        this.bp = -1;
        this.scanChar();
    }

    public boolean eof() {
        return this.pos >= this.eofPos - 1;
    }

    public String rest() {
        if (this.eof()) {
            return null;
        }
        return new String(Arrays.copyOfRange(this.buf, this.pos, this.buf.length));
    }

    protected final void scanChar() {
        this.ch = this.buf[++this.bp];
    }

    protected void lexError(int pos, String key, Object ... args) {
        this.token = Token.ERROR;
    }

    private void lexError(String key, Object ... args) {
        this.lexError(this.pos, key, args);
    }

    public final Token token() {
        return this.token;
    }

    public final void nextText() {
    }

    public final void nextToken() {
        this.sp = 0;
        while (true) {
            this.pos = this.bp;
            if (!Lexer.isWhitespace(this.ch)) break;
            this.scanChar();
        }
        if (CharTypes.isFirstIdentifierChar(this.ch)) {
            this.scanIdent();
            return;
        }
        if (this.ch == ',') {
            this.scanChar();
            this.token = Token.COMMA;
            return;
        }
        switch (this.ch) {
            case '0': {
                if (this.buf[this.bp + 1] == 'x') {
                    this.scanChar();
                    this.scanChar();
                    this.scanHexNumber();
                } else {
                    this.scanNumber();
                }
                return;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.scanNumber();
                return;
            }
            case '(': {
                this.scanChar();
                this.token = Token.LPAREN;
                return;
            }
            case ')': {
                this.scanChar();
                this.token = Token.RPAREN;
                return;
            }
            case '[': {
                this.scanChar();
                this.token = Token.LBRACKET;
                return;
            }
            case ']': {
                this.scanChar();
                this.token = Token.RBRACKET;
                return;
            }
            case '{': {
                this.scanChar();
                this.token = Token.LBRACE;
                return;
            }
            case '}': {
                this.scanChar();
                this.token = Token.RBRACE;
                return;
            }
            case ':': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.COLONEQ;
                } else {
                    this.token = Token.COLON;
                }
                return;
            }
            case '.': {
                this.scanChar();
                this.token = Token.DOT;
                return;
            }
            case '\'': {
                this.scanString();
                return;
            }
            case '\"': {
                this.scanAlias();
                return;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                return;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                return;
            }
            case ';': {
                this.scanChar();
                this.token = Token.SEMI;
                return;
            }
        }
        if (Character.isLetter(this.ch)) {
            this.scanIdent();
            return;
        }
        if (this.isOperator(this.ch)) {
            this.scanOperator();
            return;
        }
        if (this.bp == this.buflen || this.ch == '\u001a' && this.bp + 1 == this.buflen) {
            this.token = Token.EOF;
            this.pos = this.bp = this.eofPos;
        } else {
            this.lexError("illegal.char", String.valueOf((int)this.ch));
            this.scanChar();
        }
    }

    public static final boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f' || ch == '\b';
    }

    private final void scanOperator() {
        switch (this.ch) {
            case '+': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.PLUSEQ;
                    break;
                }
                if (this.ch == '+') {
                    this.scanChar();
                    this.token = Token.PLUSPLUS;
                    break;
                }
                this.token = Token.PLUS;
                break;
            }
            case '-': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.SUBEQ;
                    break;
                }
                if (this.ch == '-') {
                    this.scanChar();
                    this.token = Token.SUBSUB;
                    break;
                }
                this.token = Token.SUB;
                break;
            }
            case '*': {
                this.scanChar();
                this.token = Token.STAR;
                break;
            }
            case '/': {
                this.scanChar();
                this.token = Token.SLASH;
                break;
            }
            case '&': {
                this.scanChar();
                if (this.ch == '&') {
                    this.scanChar();
                    this.token = Token.AMPAMP;
                    break;
                }
                this.token = Token.AMP;
                break;
            }
            case '|': {
                this.scanChar();
                if (this.ch == '|') {
                    this.scanChar();
                    this.token = Token.BARBAR;
                    break;
                }
                this.token = Token.BAR;
                break;
            }
            case '^': {
                this.scanChar();
                this.token = Token.CARET;
                break;
            }
            case '%': {
                this.scanChar();
                this.token = Token.PERCENT;
                break;
            }
            case '=': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.EQEQ;
                    break;
                }
                this.token = Token.EQ;
                break;
            }
            case '>': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.GTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.GTGT;
                    break;
                }
                this.token = Token.GT;
                break;
            }
            case '<': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    if (this.ch == '>') {
                        this.token = Token.LTEQGT;
                        this.scanChar();
                        break;
                    }
                    this.token = Token.LTEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.LTGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.LTLT;
                    break;
                }
                this.token = Token.LT;
                break;
            }
            case '!': {
                this.scanChar();
                if (this.ch == '=') {
                    this.scanChar();
                    this.token = Token.BANGEQ;
                    break;
                }
                if (this.ch == '>') {
                    this.scanChar();
                    this.token = Token.BANGGT;
                    break;
                }
                if (this.ch == '<') {
                    this.scanChar();
                    this.token = Token.BANGLT;
                    break;
                }
                this.token = Token.BANG;
                break;
            }
            case '?': {
                this.scanChar();
                this.token = Token.QUES;
                break;
            }
            case '~': {
                this.scanChar();
                this.token = Token.TILDE;
                break;
            }
            default: {
                throw new ElParseException("TODO");
            }
        }
    }

    protected void scanString() {
        char ch;
        this.np = this.bp;
        boolean hasSpecial = false;
        block12: while ((ch = this.buf[++this.bp]) != '\'') {
            if (ch == '\u001a') {
                throw new ElParseException("unclosed single-quote string");
            }
            if (ch == '\\') {
                char oc1;
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp > this.sbuf.length) {
                        char[] newsbuf = new char[this.sp * 2];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                ch = this.buf[++this.bp];
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case '\'': {
                        this.putChar('\'');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'u': {
                        char c1 = ch = this.buf[++this.bp];
                        char c2 = ch = this.buf[++this.bp];
                        char c3 = ch = this.buf[++this.bp];
                        char c4 = ch = this.buf[++this.bp];
                        int val = Integer.parseInt(new String(new char[]{c1, c2, c3, c4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                if (CharTypes.isZeroToThree(ch)) {
                    if (this.buf.length > this.bp + 2) {
                        oc1 = this.buf[++this.bp];
                        char oc2 = this.buf[++this.bp];
                        int oval = Integer.parseInt(new String(new char[]{ch, oc1, oc2}), 8);
                        this.putChar((char)oval);
                        ch = oc2;
                        continue;
                    }
                } else if (CharTypes.isOctalDigit(ch)) {
                    if (CharTypes.isOctalDigit(this.buf[this.bp + 1])) {
                        oc1 = this.buf[++this.bp];
                        int oval = Integer.parseInt(new String(new char[]{ch, oc1}), 8);
                        this.putChar((char)oval);
                        ch = oc1;
                        continue;
                    }
                    int oval = Integer.parseInt(new String(new char[]{ch}), 8);
                    this.putChar((char)oval);
                    continue;
                }
                this.ch = ch;
                throw new ElParseException("Unclosed single-quote string, incorrect octal escape char '" + ch + "'");
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
        this.token = Token.LITERAL_STRING;
        this.ch = this.buf[++this.bp];
    }

    private final void scanAlias() {
        char ch;
        this.np = this.bp;
        boolean hasSpecial = false;
        block12: while ((ch = this.buf[++this.bp]) != '\"') {
            if (ch == '\\') {
                if (!hasSpecial) {
                    hasSpecial = true;
                    if (this.sp >= this.sbuf.length) {
                        int newCapcity = this.sbuf.length * 2;
                        if (this.sp > newCapcity) {
                            newCapcity = this.sp;
                        }
                        char[] newsbuf = new char[newCapcity];
                        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
                        this.sbuf = newsbuf;
                    }
                    System.arraycopy(this.buf, this.np + 1, this.sbuf, 0, this.sp);
                }
                ch = this.buf[++this.bp];
                switch (ch) {
                    case '\"': {
                        this.putChar('\"');
                        continue block12;
                    }
                    case '\\': {
                        this.putChar('\\');
                        continue block12;
                    }
                    case '/': {
                        this.putChar('/');
                        continue block12;
                    }
                    case 'b': {
                        this.putChar('\b');
                        continue block12;
                    }
                    case 'F': 
                    case 'f': {
                        this.putChar('\f');
                        continue block12;
                    }
                    case 'n': {
                        this.putChar('\n');
                        continue block12;
                    }
                    case 'r': {
                        this.putChar('\r');
                        continue block12;
                    }
                    case 't': {
                        this.putChar('\t');
                        continue block12;
                    }
                    case 'x': {
                        char x1 = ch = this.buf[++this.bp];
                        char x2 = ch = this.buf[++this.bp];
                        int x_val = digits[x1] * 16 + digits[x2];
                        char x_char = (char)x_val;
                        this.putChar(x_char);
                        continue block12;
                    }
                    case 'u': {
                        char u1 = ch = this.buf[++this.bp];
                        char u2 = ch = this.buf[++this.bp];
                        char u3 = ch = this.buf[++this.bp];
                        char u4 = ch = this.buf[++this.bp];
                        int val = Integer.parseInt(new String(new char[]{u1, u2, u3, u4}), 16);
                        this.putChar((char)val);
                        continue block12;
                    }
                }
                this.ch = ch;
                throw new ElParseException("unclosed string");
            }
            if (!hasSpecial) {
                ++this.sp;
                continue;
            }
            if (this.sp == this.sbuf.length) {
                this.putChar(ch);
                continue;
            }
            this.sbuf[this.sp++] = ch;
        }
        this.stringVal = !hasSpecial ? new String(this.buf, this.np + 1, this.sp) : new String(this.sbuf, 0, this.sp);
        this.token = Token.LITERAL_STRING;
        this.ch = this.buf[++this.bp];
    }

    public void scanVariable() {
        char ch;
        int first = this.ch;
        if (this.ch != '@' && this.ch != ':') {
            throw new ElParseException("illegal variable");
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        if (this.buf[this.bp + 1] == '@') {
            hash = 31 * hash + 64;
            ++this.bp;
            ++this.sp;
        }
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        Token tok = this.keywods.getToken(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    public void scanIdent() {
        char ch;
        int first = this.ch;
        boolean firstFlag = CharTypes.isFirstIdentifierChar((char)first);
        if (!firstFlag) {
            throw new ElParseException("illegal identifier");
        }
        int hash = first;
        this.np = this.bp;
        this.sp = 1;
        while (CharTypes.isIdentifierChar(ch = this.buf[++this.bp])) {
            hash = 31 * hash + ch;
            ++this.sp;
        }
        this.ch = this.buf[this.bp];
        this.stringVal = this.symbolTable.addSymbol(this.buf, this.np, this.sp, hash);
        Token tok = this.keywods.getToken(this.stringVal);
        this.token = tok != null ? tok : Token.IDENTIFIER;
    }

    public void scanNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (this.ch >= '0' && this.ch <= '9') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        boolean isDouble = false;
        boolean isFloat = false;
        if (this.ch == '.') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            isDouble = true;
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            if (this.ch == 'f') {
                isFloat = true;
            }
        }
        if (this.ch == 'e' || this.ch == 'E') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            if (this.ch == '+' || this.ch == '-') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                ++this.sp;
                this.ch = this.buf[++this.bp];
            }
            isDouble = true;
            if (this.ch == 'f') {
                isFloat = true;
            }
        }
        this.token = isDouble ? (isFloat ? Token.LITERAL_FLOAT : Token.LITERAL_DOUBLE) : Token.LITERAL_INT;
    }

    public void scanHexNumber() {
        this.np = this.bp++;
        if (this.ch == '-') {
            ++this.sp;
            this.ch = this.buf[this.bp];
        }
        while (CharTypes.isHex(this.ch)) {
            ++this.sp;
            this.ch = this.buf[++this.bp];
        }
        if (this.ch == 'L' || this.ch == 'l') {
            ++this.sp;
            this.ch = this.buf[++this.bp];
            this.token = Token.LITERAL_HEX_LONG;
        } else {
            this.token = Token.LITERAL_HEX;
        }
    }

    public String hexStringWithPrefix() {
        if (this.token == Token.LITERAL_HEX_LONG) {
            return new String(this.buf, this.np - 2, this.sp + 1);
        }
        return new String(this.buf, this.np - 2, this.sp + 2);
    }

    public final boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected final void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] newsbuf = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
            this.sbuf = newsbuf;
        }
        this.sbuf[this.sp++] = ch;
    }

    public final int pos() {
        return this.pos;
    }

    public final String stringVal() {
        return this.stringVal;
    }

    private boolean isOperator(char ch) {
        switch (ch) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    public Number integerValue() throws NumberFormatException {
        int digit;
        long multmin;
        long limit;
        long result = 0L;
        boolean negative = false;
        int i = this.np;
        int max = this.np + this.sp;
        if (this.buf[this.np] == '-') {
            negative = true;
            limit = Long.MIN_VALUE;
            ++i;
        } else {
            limit = -9223372036854775807L;
        }
        long l = multmin = negative ? -922337203685477580L : -922337203685477580L;
        if (i < max) {
            digit = digits[this.buf[i++]];
            result = -digit;
        }
        while (i < max) {
            digit = digits[this.buf[i++]];
            if (result < multmin) {
                return new BigInteger(this.numberString());
            }
            if ((result *= 10L) < limit + (long)digit) {
                return new BigInteger(this.numberString());
            }
            result -= (long)digit;
        }
        if (negative) {
            if (i > this.np + 1) {
                if (result >= Integer.MIN_VALUE) {
                    return (int)result;
                }
                return result;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((result = -result) <= Integer.MAX_VALUE) {
            return (int)result;
        }
        return result;
    }

    public final String numberString() {
        return new String(this.buf, this.np, this.sp);
    }

    public BigDecimal decimalValue() {
        return new BigDecimal(this.buf, this.np, this.sp);
    }

    static {
        for (int i = 48; i <= 57; ++i) {
            Lexer.digits[i] = i - 48;
        }
    }
}

