/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.el.spel.parser;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import leap.lang.el.DefaultElParseContext;
import leap.lang.el.ElParseContext;
import leap.lang.el.ElParseException;
import leap.lang.el.spel.ast.AstBinary;
import leap.lang.el.spel.ast.AstBoolean;
import leap.lang.el.spel.ast.AstChoice;
import leap.lang.el.spel.ast.AstExpr;
import leap.lang.el.spel.ast.AstFunction;
import leap.lang.el.spel.ast.AstIdentifier;
import leap.lang.el.spel.ast.AstItem;
import leap.lang.el.spel.ast.AstMethod;
import leap.lang.el.spel.ast.AstNull;
import leap.lang.el.spel.ast.AstNumber;
import leap.lang.el.spel.ast.AstProperty;
import leap.lang.el.spel.ast.AstString;
import leap.lang.el.spel.ast.AstType;
import leap.lang.el.spel.ast.AstUnary;
import leap.lang.el.spel.parser.Lexer;
import leap.lang.el.spel.parser.Token;

public class Parser {
    private static final ElParseContext EMPTY_CONTEXT = new DefaultElParseContext();
    private static final String T = "T";
    protected final ElParseContext context;
    protected final Lexer lexer;
    private int quesCounter;

    public static AstExpr parse(String text) {
        return new Parser(text).expr();
    }

    public static AstExpr parse(ElParseContext context, String text) {
        return new Parser(context, text).parse();
    }

    public Parser(String input) {
        this(EMPTY_CONTEXT, input);
    }

    public Parser(ElParseContext context, String input) {
        this.context = context;
        this.lexer = new Lexer(input);
        this.lexer.nextToken();
    }

    public AstExpr parse() {
        return this.parse(false);
    }

    public AstExpr parse(boolean allowRest) {
        AstExpr expr = this.expr();
        if (!this.eof() && !allowRest) {
            throw new ElParseException("multi-expressions not allowed");
        }
        return expr;
    }

    protected AstExpr expr() {
        AstExpr expr = this.primary();
        if (this.lexer.token() == Token.COMMA) {
            return expr;
        }
        return this.exprRest(expr);
    }

    public boolean eof() {
        return this.lexer.eof();
    }

    public String rest() {
        return this.lexer.rest();
    }

    protected AstExpr exprRest(AstExpr expr) {
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.shiftRest(expr);
        expr = this.relationalRest(expr);
        expr = this.equalityRest(expr);
        expr = this.bitAndRest(expr);
        expr = this.bitXorRest(expr);
        expr = this.bitOrRest(expr);
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        expr = this.choiceRest(expr);
        expr = this.assignRest(expr);
        return expr;
    }

    protected Lexer lexer() {
        return this.lexer;
    }

    protected void accept(Token token) {
        if (this.lexer.token() != token) {
            throw new ElParseException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token()));
        }
        this.lexer.nextToken();
    }

    protected final AstExpr bitXor() {
        AstExpr expr = this.bitAnd();
        return this.bitXorRest(expr);
    }

    protected AstExpr bitXorRest(AstExpr expr) {
        if (this.lexer.token() == Token.CARET) {
            this.lexer.nextToken();
            AstExpr rightExp = this.bitAnd();
            expr = new AstBinary(expr, AstBinary.BIT_XOR, rightExp);
            expr = this.bitXorRest(expr);
        }
        return expr;
    }

    protected final AstExpr multiplicative() {
        AstExpr expr = this.primary();
        return this.multiplicativeRest(expr);
    }

    protected AstExpr multiplicativeRest(AstExpr expr) {
        if (this.lexer.token() == Token.STAR) {
            this.lexer.nextToken();
            AstExpr rightExp = this.primary();
            expr = new AstBinary(expr, AstBinary.MUL, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this.lexer.token() == Token.SLASH) {
            this.lexer.nextToken();
            AstExpr rightExp = this.primary();
            expr = new AstBinary(expr, AstBinary.DIV, rightExp);
            expr = this.multiplicativeRest(expr);
        } else if (this.lexer.token() == Token.PERCENT) {
            this.lexer.nextToken();
            AstExpr rightExp = this.primary();
            expr = new AstBinary(expr, AstBinary.MOD, rightExp);
            expr = this.multiplicativeRest(expr);
        }
        return expr;
    }

    protected final AstExpr bitAnd() {
        AstExpr expr = this.equality();
        return this.orRest(expr);
    }

    protected final AstExpr bitAndRest(AstExpr expr) {
        while (this.lexer.token() == Token.AMP) {
            this.lexer.nextToken();
            AstExpr rightExp = this.equality();
            expr = new AstBinary(expr, AstBinary.BIT_AND, rightExp);
        }
        return expr;
    }

    protected final AstExpr bitOr() {
        AstExpr expr = this.bitXor();
        return this.orRest(expr);
    }

    protected final AstExpr bitOrRest(AstExpr expr) {
        while (this.lexer.token() == Token.BAR) {
            this.lexer.nextToken();
            AstExpr rightExp = this.bitXor();
            expr = new AstBinary(expr, AstBinary.BIT_OR, rightExp);
        }
        return expr;
    }

    protected final AstExpr equality() {
        AstExpr expr = this.relational();
        return this.equalityRest(expr);
    }

    protected final AstExpr equalityRest(AstExpr expr) {
        if (this.lexer.token() == Token.EQEQ) {
            this.lexer.nextToken();
            AstExpr rightExp = this.relational();
            expr = new AstBinary(expr, AstBinary.EQ, rightExp);
        } else if (this.lexer.token() == Token.BANGEQ) {
            this.lexer.nextToken();
            AstExpr rightExp = this.relational();
            expr = new AstBinary(expr, AstBinary.NE, rightExp);
        }
        return expr;
    }

    protected final AstExpr additive() {
        AstExpr expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    protected AstExpr additiveRest(AstExpr expr) {
        if (this.lexer.token() == Token.PLUS) {
            this.lexer.nextToken();
            AstExpr rightExp = this.multiplicative();
            expr = new AstBinary(expr, AstBinary.ADD, rightExp);
            expr = this.additiveRest(expr);
        } else if (this.lexer.token() == Token.SUB) {
            this.lexer.nextToken();
            AstExpr rightExp = this.multiplicative();
            expr = new AstBinary(expr, AstBinary.SUB, rightExp);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    protected final AstExpr shift() {
        AstExpr expr = this.additive();
        return this.shiftRest(expr);
    }

    protected AstExpr shiftRest(AstExpr expr) {
        if (this.lexer.token() == Token.LTLT) {
            this.lexer.nextToken();
            AstExpr rightExp = this.additive();
            expr = new AstBinary(expr, AstBinary.LSHIFT, rightExp);
            expr = this.shiftRest(expr);
        } else if (this.lexer.token() == Token.GTGT) {
            this.lexer.nextToken();
            AstExpr rightExp = this.additive();
            expr = new AstBinary(expr, AstBinary.RSHIFT, rightExp);
            expr = this.shiftRest(expr);
        }
        return expr;
    }

    protected final AstExpr and() {
        AstExpr expr = this.bitOr();
        return this.andRest(expr);
    }

    protected final AstExpr andRest(AstExpr expr) {
        if (this.lexer.token() == Token.AMPAMP) {
            this.lexer.nextToken();
            AstExpr rightExp = this.bitOr();
            expr = new AstBinary(expr, AstBinary.AND, rightExp);
            expr = this.andRest(expr);
        }
        return expr;
    }

    protected final AstExpr or() {
        AstExpr expr = this.and();
        return this.orRest(expr);
    }

    protected final AstExpr orRest(AstExpr expr) {
        if (this.lexer.token() == Token.BARBAR) {
            this.lexer.nextToken();
            AstExpr rightExp = this.and();
            expr = new AstBinary(expr, AstBinary.OR, rightExp);
            expr = this.orRest(expr);
        }
        return expr;
    }

    protected final AstExpr conditional() {
        AstExpr expr = this.or();
        return this.choiceRest(expr);
    }

    protected final AstExpr choiceRest(AstExpr expr) {
        if (this.lexer.token() == Token.QUES) {
            ++this.quesCounter;
            this.lexer.nextToken();
            AstExpr trueExpr = this.expr();
            this.accept(Token.COLON);
            --this.quesCounter;
            AstExpr falseExpr = this.expr();
            expr = new AstChoice(expr, trueExpr, falseExpr);
            expr = this.choiceRest(expr);
        }
        return expr;
    }

    protected final AstExpr assign() {
        AstExpr expr = this.conditional();
        return this.assignRest(expr);
    }

    protected final AstExpr assignRest(AstExpr expr) {
        AstExpr rightExp;
        if (this.lexer.token() == Token.EQ) {
            this.lexer.nextToken();
            rightExp = this.conditional();
            expr = new AstBinary(expr, AstBinary.ASSIGN, rightExp);
            expr = this.assignRest(expr);
        }
        if (this.lexer.token() == Token.PLUSEQ) {
            this.lexer.nextToken();
            rightExp = this.conditional();
            expr = new AstBinary(expr, AstBinary.ADD_ASSIGN, rightExp);
            expr = this.assignRest(expr);
        }
        return expr;
    }

    protected final AstExpr relational() {
        AstExpr expr = this.shift();
        return this.relationalRest(expr);
    }

    public AstExpr relationalRest(AstExpr expr) {
        if (this.lexer.token() == Token.LT) {
            this.lexer.nextToken();
            AstExpr rightExp = this.shift();
            expr = new AstBinary(expr, AstBinary.LT, rightExp);
        } else if (this.lexer.token() == Token.LTEQ) {
            this.lexer.nextToken();
            AstExpr rightExp = this.shift();
            expr = new AstBinary(expr, AstBinary.LE, rightExp);
        } else if (this.lexer.token() == Token.GT) {
            this.lexer.nextToken();
            AstExpr rightExp = this.shift();
            expr = new AstBinary(expr, AstBinary.GT, rightExp);
        } else if (this.lexer.token() == Token.GTEQ) {
            this.lexer.nextToken();
            AstExpr rightExp = this.shift();
            expr = new AstBinary(expr, AstBinary.GE, rightExp);
        } else if (this.lexer.token() == Token.INSTNACEOF) {
            this.lexer.nextToken();
            AstExpr rightExp = this.shift();
            expr = new AstBinary(expr, AstBinary.INSTANCE_OF, rightExp);
        }
        return expr;
    }

    protected final AstExpr name() throws ElParseException {
        if (this.lexer.token() != Token.IDENTIFIER) {
            throw new ElParseException("error : " + (Object)((Object)this.lexer.token()));
        }
        String identName = this.lexer.stringVal();
        this.lexer.nextToken();
        AstExpr name = new AstIdentifier(this.context, identName);
        while (this.lexer.token() == Token.DOT) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER) {
                throw new ElParseException("error : " + (Object)((Object)this.lexer.token()));
            }
            name = new AstProperty(this.context, name, this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return name;
    }

    public AstExpr primary() {
        AstExpr primaryExpr = null;
        Token tok = this.lexer.token();
        block0 : switch (tok) {
            case LPAREN: {
                this.lexer.nextToken();
                primaryExpr = this.expr();
                this.accept(Token.RPAREN);
                break;
            }
            case IDENTIFIER: {
                this.lexer.nextToken();
                primaryExpr = new AstIdentifier(this.context, this.lexer.stringVal());
                break;
            }
            case PLUSPLUS: {
                this.lexer.nextToken();
                primaryExpr = this.expr();
                primaryExpr = new AstUnary(primaryExpr, AstUnary.PRE_PLUSPLUS);
                break;
            }
            case SUBSUB: {
                this.lexer.nextToken();
                primaryExpr = this.expr();
                primaryExpr = new AstUnary(primaryExpr, AstUnary.PRE_SUBSUB);
                break;
            }
            case BANG: {
                this.lexer.nextToken();
                primaryExpr = this.primary();
                primaryExpr = new AstUnary(primaryExpr, AstUnary.NOT);
                break;
            }
            case TRUE: {
                primaryExpr = new AstBoolean(true);
                this.lexer.nextToken();
                break;
            }
            case FALSE: {
                primaryExpr = new AstBoolean(false);
                this.lexer.nextToken();
                break;
            }
            case LITERAL_INT: {
                primaryExpr = new AstNumber(this.lexer.integerValue());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_FLOAT: {
                primaryExpr = new AstNumber(Float.valueOf(this.lexer.decimalValue().floatValue()));
                this.lexer.nextToken();
                break;
            }
            case LITERAL_DOUBLE: {
                primaryExpr = new AstNumber(this.lexer.decimalValue().doubleValue());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_STRING: {
                primaryExpr = new AstString(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case SUB: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        long longVal;
                        int intVal;
                        Number integerValue = this.lexer.integerValue();
                        integerValue = integerValue instanceof Integer ? (Number)((intVal = ((Integer)integerValue).intValue()) == Integer.MIN_VALUE ? (Number)((long)intVal * -1L) : (Number)(intVal * -1)) : (Number)(integerValue instanceof Long ? ((longVal = ((Long)integerValue).longValue()) == 0x80000000L ? (Number)((int)(longVal * -1L)) : (Number)(longVal * -1L)) : ((BigInteger)integerValue).negate());
                        primaryExpr = new AstNumber(integerValue);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        primaryExpr = new AstNumber(Float.valueOf(this.lexer.decimalValue().negate().floatValue()));
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_DOUBLE: {
                        primaryExpr = new AstNumber(this.lexer.decimalValue().negate().doubleValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                }
                primaryExpr = this.expr();
                primaryExpr = new AstUnary(primaryExpr, AstUnary.MINUS);
                break;
            }
            case PLUS: {
                this.lexer.nextToken();
                switch (this.lexer.token()) {
                    case LITERAL_INT: {
                        primaryExpr = new AstNumber(this.lexer.integerValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        primaryExpr = new AstNumber(Float.valueOf(this.lexer.decimalValue().floatValue()));
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_DOUBLE: {
                        primaryExpr = new AstNumber(this.lexer.decimalValue().doubleValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                }
                primaryExpr = this.expr();
                primaryExpr = new AstUnary(primaryExpr, AstUnary.PLUS);
                break;
            }
            case NULL: {
                primaryExpr = new AstNull();
                this.lexer.nextToken();
                break;
            }
            case LITERAL_HEX: {
                primaryExpr = new AstNumber(Integer.decode(this.lexer.hexStringWithPrefix()));
                this.lexer.nextToken();
                break;
            }
            case LITERAL_HEX_LONG: {
                primaryExpr = new AstNumber(Long.decode(this.lexer.hexStringWithPrefix()));
                this.lexer.nextToken();
                break;
            }
            case LBRACKET: {
                this.lexer.nextToken();
                AstExpr indexExpr = this.expr();
                this.accept(Token.RBRACKET);
                primaryExpr = new AstItem(null, indexExpr);
                break;
            }
            case ERROR: {
                throw new ElParseException("Error parse expression at pos " + this.lexer.pos() + ", character '" + this.lexer.buf[this.lexer.pos()] + "'");
            }
            default: {
                throw new ElParseException("Error. unsupported token : " + (Object)((Object)tok));
            }
        }
        return this.primaryRest(primaryExpr);
    }

    public AstExpr primaryRest(AstExpr expr) throws ElParseException {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        if (this.lexer.token() == Token.DOT) {
            this.lexer.nextToken();
            if (this.lexer.token() == Token.STAR) {
                this.lexer.nextToken();
                expr = new AstProperty(this.context, expr, "*");
            } else {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ElParseException("error");
                }
                String name = this.lexer.stringVal();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    this.lexer.nextToken();
                    ArrayList<AstExpr> params = new ArrayList<AstExpr>();
                    if (this.lexer.token() == Token.RPAREN) {
                        this.lexer.nextToken();
                    } else {
                        this.exprList(params);
                        this.accept(Token.RPAREN);
                    }
                    expr = new AstMethod(expr, name, params.toArray(new AstExpr[params.size()]));
                } else {
                    expr = new AstProperty(this.context, expr, name);
                }
            }
            expr = this.primaryRest(expr);
        } else if (this.lexer.token() == Token.PLUSPLUS) {
            this.lexer.nextToken();
            expr = new AstUnary(expr, AstUnary.POST_PLUSPLUS);
            expr = this.primaryRest(expr);
        } else if (this.lexer.token() == Token.SUBSUB) {
            this.lexer.nextToken();
            expr = new AstUnary(expr, AstUnary.POST_SUBSUB);
            expr = this.primaryRest(expr);
        } else if (this.lexer.token() == Token.LBRACKET) {
            this.lexer.nextToken();
            AstExpr indexExpr = this.expr();
            this.accept(Token.RBRACKET);
            expr = new AstItem(expr, indexExpr);
            expr = this.primaryRest(expr);
        } else if (this.lexer.token() == Token.COLONEQ) {
            this.lexer.nextToken();
            AstExpr rightExp = this.primary();
            expr = new AstBinary(expr, AstBinary.ASSIGN, rightExp);
        } else {
            if (this.lexer.token() == Token.COLON && this.quesCounter == 0) {
                String prefix = this.lexer.stringVal();
                this.lexer.nextToken();
                this.accept(Token.IDENTIFIER);
                String name = this.lexer.stringVal();
                this.accept(Token.LPAREN);
                ArrayList<AstExpr> params = new ArrayList<AstExpr>();
                if (this.lexer.token() != Token.RPAREN) {
                    this.exprList(params);
                }
                this.accept(Token.RPAREN);
                return this.primaryRest(new AstFunction(this.context, prefix, name, params.toArray(new AstExpr[params.size()])));
            }
            if (this.lexer.token() == Token.LPAREN) {
                if (expr instanceof AstIdentifier) {
                    AstIdentifier identExpr = (AstIdentifier)expr;
                    String name = identExpr.getName();
                    this.lexer.nextToken();
                    ArrayList<AstExpr> params = new ArrayList<AstExpr>();
                    if (this.lexer.token() != Token.RPAREN) {
                        this.exprList(params);
                    }
                    this.accept(Token.RPAREN);
                    return this.primaryRest(this.createFunction(this.context, name, params));
                }
                throw new ElParseException("not support token:");
            }
        }
        return expr;
    }

    protected final void exprList(Collection<AstExpr> c) throws ElParseException {
        if (this.lexer.token() == Token.RPAREN) {
            return;
        }
        if (this.lexer.token() == Token.EOF) {
            return;
        }
        AstExpr expr = this.expr();
        c.add(expr);
        while (this.lexer.token() == Token.COMMA) {
            this.lexer.nextToken();
            expr = this.expr();
            c.add(expr);
        }
    }

    protected AstExpr createFunction(ElParseContext context, String name, List<AstExpr> params) {
        AstExpr e;
        if (name.equals(T) & params.size() == 1 && ((e = params.get(0)) instanceof AstProperty || e instanceof AstIdentifier)) {
            return new AstType(context, e.toString());
        }
        return new AstFunction(context, name, params.toArray(new AstExpr[params.size()]));
    }
}

