/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.expression;

import java.util.Map;
import leap.lang.expression.AbstractExpression;
import leap.lang.expression.Expression;

public class CompositeExpression
extends AbstractExpression {
    public static final CompositeExpression NULL = new CompositeExpression(null);
    public static final CompositeExpression EMPTY = new CompositeExpression("");
    private final String string;
    private final Object[] nodes;

    public CompositeExpression(String string) {
        this.string = string;
        this.nodes = null;
    }

    public CompositeExpression(String string, Object[] nodes) {
        this.string = string;
        this.nodes = nodes;
    }

    public boolean isTextOnly() {
        return null == this.nodes;
    }

    @Override
    protected Object eval(Object context, Map<String, Object> vars) {
        if (null == this.nodes) {
            return this.string;
        }
        if (this.nodes.length == 1) {
            return this.evalNode(context, vars, this.nodes[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.nodes.length; ++i) {
            sb.append(this.evalNode(context, vars, this.nodes[i]));
        }
        return sb.toString();
    }

    protected String evalNode(Object context, Map<String, Object> vars, Object node) {
        if (node instanceof String) {
            return (String)node;
        }
        String string = ((Expression)node).getValue(String.class, context, vars);
        return string == null ? "" : string;
    }

    public String toString() {
        return this.string;
    }
}

