/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.extension;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import leap.lang.Props;
import leap.lang.accessor.PropertyGetter;
import leap.lang.beans.BeanProperty;
import leap.lang.beans.BeanType;
import leap.lang.convert.Converts;
import leap.lang.exception.NestedIOException;
import leap.lang.text.PlaceholderResolver;

public class ExProperties
extends Properties
implements PropertyGetter {
    private static final long serialVersionUID = -7225067603324341854L;
    private File file;

    public static ExProperties load(File file) {
        return Props.load(file);
    }

    public static ExProperties load(File file, Properties defaults) {
        return Props.load(file);
    }

    public static ExProperties create(Map<String, String> defaults) {
        ExProperties p = new ExProperties();
        p.putAll(defaults);
        return p;
    }

    public static ExProperties create(Properties properties) {
        return new ExProperties(properties);
    }

    public ExProperties() {
    }

    public ExProperties(Properties defaults) {
        super(defaults);
    }

    public ExProperties(File file) {
        this.file = file;
    }

    public ExProperties(File file, Properties defaults) {
        super(defaults);
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public String removeProperty(String name) {
        return (String)this.remove(name);
    }

    public boolean hasProperty(String name) {
        return this.containsKey(name);
    }

    public Map<String, String> toMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        if (null != this.defaults) {
            for (Map.Entry<Object, Object> entry : this.defaults.entrySet()) {
                if (map.containsKey(entry.getKey())) continue;
                map.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return map;
    }

    public Map<String, String> toMap(PlaceholderResolver pr) {
        if (null == pr) {
            return this.toMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (Map.Entry<Object, Object> entry : this.entrySet()) {
            map.put((String)entry.getKey(), pr.resolveString((String)entry.getValue()));
        }
        if (null != this.defaults) {
            for (Map.Entry<Object, Object> entry : this.defaults.entrySet()) {
                if (map.containsKey(entry.getKey())) continue;
                map.put((String)entry.getKey(), pr.resolveString((String)entry.getValue()));
            }
        }
        return map;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (null == value) {
            value = "";
        }
        return super.put(key, value);
    }

    @Override
    public synchronized String get(Object key) {
        return this.getProperty(key.toString());
    }

    public <T> T get(String key, Class<T> type) {
        return Props.get(this, key, type);
    }

    public Boolean getBoolean(String key) {
        return Props.getBoolean(this, key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return Props.getBoolean(this, key, defaultValue);
    }

    public Integer getInteger(String key) {
        return Props.getInteger(this, key);
    }

    public int getInteger(String key, int defaultValue) {
        return Props.getInteger(this, key, defaultValue);
    }

    public <T> T toBean(Class<T> cls) {
        return Converts.toBean(this.toMap(), cls);
    }

    public void inject(Object bean) {
        if (null != bean) {
            BeanType bt = BeanType.of(bean.getClass());
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String name = (String)entry.getKey();
                BeanProperty bp = bt.getProperty(name);
                if (null == bp) continue;
                bp.setValue(bean, entry.getValue());
            }
        }
    }

    public void save() throws IllegalStateException, NestedIOException {
        if (null == this.file) {
            throw new IllegalStateException("Cannot save, this properties not load from file");
        }
        Props.save(this, this.file);
    }

    public void save(File file) throws NestedIOException {
        Props.save(this, file);
    }
}

