/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.html;

import java.io.IOException;
import leap.lang.html.HtmlCharacterEntityDecoder;
import leap.lang.html.HtmlCharacterEntityReferences;

public class HTML {
    private static final HtmlCharacterEntityReferences characterEntityReferences = new HtmlCharacterEntityReferences();

    public static String escape(CharSequence input) {
        if (input == null) {
            return null;
        }
        StringBuilder escaped = new StringBuilder(input.length() * 2);
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            String reference = characterEntityReferences.convertToReference(character);
            if (reference != null) {
                escaped.append(reference);
                continue;
            }
            escaped.append(character);
        }
        return escaped.toString();
    }

    public static String escape(char c) {
        return characterEntityReferences.convertToReference(c);
    }

    public static void escapeAndAppend(char c, Appendable out) throws IOException {
        String s = characterEntityReferences.convertToReference(c);
        if (null == s) {
            out.append(c);
        } else {
            out.append(s);
        }
    }

    public static void escapeAndAppend(CharSequence cs, Appendable out) throws IOException {
        if (null == cs) {
            return;
        }
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            String s = characterEntityReferences.convertToReference(c);
            if (null == s) {
                out.append(c);
                continue;
            }
            out.append(s);
        }
    }

    public static String unescape(String input) {
        if (input == null) {
            return null;
        }
        return new HtmlCharacterEntityDecoder(characterEntityReferences, input).decode();
    }

    protected HTML() {
    }
}

