/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

public class HTTP {
    public static int SC_CONTINUE = 100;
    public static int SC_SWITCHING_PROTOCOLS = 101;
    public static int SC_PROCESSING = 102;
    public static int SC_OK = 200;
    public static int SC_CREATED = 201;
    public static int SC_ACCEPTED = 202;
    public static int SC_NON_AUTHORITATIVE_INFORMATION = 203;
    public static int SC_NO_CONTENT = 204;
    public static int SC_RESET_CONTENT = 205;
    public static int SC_PARTIAL_CONTENT = 206;
    public static int SC_MULTI_STATUS = 207;
    public static int SC_MULTIPLE_CHOICES = 300;
    public static int SC_MOVED_PERMANENTLY = 301;
    public static int SC_MOVED_TEMPORARILY = 302;
    public static int SC_FOUND = 302;
    public static int SC_SEE_OTHER = 303;
    public static int SC_NOT_MODIFIED = 304;
    public static int SC_USE_PROXY = 305;
    public static int SC_TEMPORARY_REDIRECT = 307;
    public static int SC_BAD_REQUEST = 400;
    public static int SC_UNAUTHORIZED = 401;
    public static int SC_PAYMENT_REQUIRED = 402;
    public static int SC_FORBIDDEN = 403;
    public static int SC_NOT_FOUND = 404;
    public static int SC_METHOD_NOT_ALLOWED = 405;
    public static int SC_NOT_ACCEPTABLE = 406;
    public static int SC_PROXY_AUTHENTICATION_REQUIRED = 407;
    public static int SC_REQUEST_TIMEOUT = 408;
    public static int SC_CONFLICT = 409;
    public static int SC_GONE = 410;
    public static int SC_LENGTH_REQUIRED = 411;
    public static int SC_PRECONDITION_FAILED = 412;
    public static int SC_REQUEST_TOO_LONG = 413;
    public static int SC_REQUEST_URI_TOO_LONG = 414;
    public static int SC_UNSUPPORTED_MEDIA_TYPE = 415;
    public static int SC_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    public static int SC_EXPECTATION_FAILED = 417;
    public static int SC_INSUFFICIENT_SPACE_ON_RESOURCE = 419;
    public static int SC_METHOD_FAILURE = 420;
    public static int SC_UNPROCESSABLE_ENTITY = 422;
    public static int SC_LOCKED = 423;
    public static int SC_FAILED_DEPENDENCY = 424;
    public static int SC_INTERNAL_SERVER_ERROR = 500;
    public static int SC_NOT_IMPLEMENTED = 501;
    public static int SC_BAD_GATEWAY = 502;
    public static int SC_SERVICE_UNAVAILABLE = 503;
    public static int SC_GATEWAY_TIMEOUT = 504;
    public static int SC_HTTP_VERSION_NOT_SUPPORTED = 505;
    public static int SC_INSUFFICIENT_STORAGE = 507;

    protected HTTP() {
    }

    public static enum Status {
        CONTINUE(100, "Continue"),
        SWITCHING_PROTOCOLS(101, "Switching Protocols"),
        PROCESSING(102, "Processing"),
        CHECKPOINT(103, "Checkpoint"),
        OK(200, "OK"),
        CREATED(201, "Created"),
        ACCEPTED(202, "Accepted"),
        NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information"),
        NO_CONTENT(204, "No Content"),
        RESET_CONTENT(205, "Reset Content"),
        PARTIAL_CONTENT(206, "Partial Content"),
        MULTI_STATUS(207, "Multi-Status"),
        ALREADY_REPORTED(208, "Already Reported"),
        IM_USED(226, "IM Used"),
        MULTIPLE_CHOICES(300, "Multiple Choices"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        FOUND(302, "Found"),
        MOVED_TEMPORARILY(302, "Moved Temporarily"),
        SEE_OTHER(303, "See Other"),
        NOT_MODIFIED(304, "Not Modified"),
        USE_PROXY(305, "Use Proxy"),
        TEMPORARY_REDIRECT(307, "Temporary Redirect"),
        RESUME_INCOMPLETE(308, "Resume Incomplete"),
        BAD_REQUEST(400, "Bad Request"),
        UNAUTHORIZED(401, "Unauthorized"),
        PAYMENT_REQUIRED(402, "Payment Required"),
        FORBIDDEN(403, "Forbidden"),
        NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        NOT_ACCEPTABLE(406, "Not Acceptable"),
        PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
        REQUEST_TIMEOUT(408, "Request Timeout"),
        CONFLICT(409, "Conflict"),
        GONE(410, "Gone"),
        LENGTH_REQUIRED(411, "Length Required"),
        PRECONDITION_FAILED(412, "Precondition Failed"),
        REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
        REQUEST_URI_TOO_LONG(414, "Request-URI Too Long"),
        UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
        REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested range not satisfiable"),
        EXPECTATION_FAILED(417, "Expectation Failed"),
        I_AM_A_TEAPOT(418, "I'm a teapot"),
        INSUFFICIENT_SPACE_ON_RESOURCE(419, "Insufficient Space On Resource"),
        METHOD_FAILURE(420, "Method Failure"),
        DESTINATION_LOCKED(421, "Destination Locked"),
        UNPROCESSABLE_ENTITY(422, "Unprocessable Entity"),
        LOCKED(423, "Locked"),
        FAILED_DEPENDENCY(424, "Failed Dependency"),
        UPGRADE_REQUIRED(426, "Upgrade Required"),
        PRECONDITION_REQUIRED(428, "Precondition Required"),
        TOO_MANY_REQUESTS(429, "Too Many Requests"),
        REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
        INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
        NOT_IMPLEMENTED(501, "Not Implemented"),
        BAD_GATEWAY(502, "Bad Gateway"),
        SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        GATEWAY_TIMEOUT(504, "Gateway Timeout"),
        HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version not supported"),
        VARIANT_ALSO_NEGOTIATES(506, "Variant Also Negotiates"),
        INSUFFICIENT_STORAGE(507, "Insufficient Storage"),
        LOOP_DETECTED(508, "Loop Detected"),
        BANDWIDTH_LIMIT_EXCEEDED(509, "Bandwidth Limit Exceeded"),
        NOT_EXTENDED(510, "Not Extended"),
        NETWORK_AUTHENTICATION_REQUIRED(511, "Network Authentication Required");

        private final int value;
        private final String reasonPhrase;

        private Status(int value, String reasonPhrase) {
            this.value = value;
            this.reasonPhrase = reasonPhrase;
        }

        public int value() {
            return this.value;
        }

        public String getReasonPhrase() {
            return this.reasonPhrase;
        }

        public String toString() {
            return Integer.toString(this.value);
        }

        public static Status valueOf(int statusCode) {
            for (Status status : Status.values()) {
                if (status.value != statusCode) continue;
                return status;
            }
            throw new IllegalArgumentException("No matching constant for [" + statusCode + "]");
        }
    }

    public static enum Method {
        NONE,
        GET,
        POST,
        PUT,
        PATCH,
        DELETE,
        OPTIONS,
        HEAD,
        TRACE;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isGet() {
            return this == GET;
        }

        public boolean isPost() {
            return this == POST;
        }
    }
}

