/*
 * Decompiled with CFR 0.152.
 */
package leap.lang.http;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import leap.lang.Strings;
import leap.lang.collection.SimpleCaseInsensitiveMap;
import leap.lang.enums.CaseType;
import leap.lang.http.HeaderParser;

public class Header
implements Serializable {
    private static final long serialVersionUID = -3825530827173249033L;
    private static final HeaderElement[] EMPTY_ELEMENTS = new HeaderElement[0];
    private final String name;
    private final String value;
    private HeaderElement[] elements;

    public Header(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public HeaderElement[] getElements() {
        if (null == this.elements) {
            this.elements = Strings.isEmpty(this.value) ? EMPTY_ELEMENTS : HeaderParser.parseElements(this.value).toArray(new HeaderElement[0]);
        }
        return this.elements;
    }

    public static final class HeaderElement {
        private final String name;
        private final String value;
        private final Map<String, String> parameters;

        HeaderElement(String name, String value, Map<String, String> parameters) {
            this.name = name;
            this.value = value;
            this.parameters = HeaderElement.createParametersMap(parameters);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getParameter(String name) {
            return this.parameters.get(name);
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }

        public static Map<String, String> createParametersMap(Map<String, String> m) {
            SimpleCaseInsensitiveMap<String> map = new SimpleCaseInsensitiveMap<String>(new LinkedHashMap(), CaseType.LOWER);
            if (null != m) {
                map.putAll(m);
            }
            return Collections.unmodifiableMap(map);
        }
    }
}

